/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.model;

import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.LoggerBase;
import com.holybuckets.foundation.datastore.DataStore;
import com.holybuckets.foundation.datastore.LevelSaveData;
import com.holybuckets.foundation.datastructure.ConcurrentSet;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.event.custom.DatastoreSaveEvent;
import com.holybuckets.foundation.exception.InvalidId;
import com.holybuckets.foundation.model.ManagedChunkBlockUpdates;
import com.holybuckets.foundation.model.ManagedChunkEvents;
import com.holybuckets.foundation.model.ManagedChunkUtility;
import com.holybuckets.foundation.modelInterface.IMangedChunkData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.event.ChunkLoadingEvent;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import org.apache.commons.lang3.tuple.Pair;

public class ManagedChunk
implements IMangedChunkData {
    public static final String CLASS_ID = "003";
    static final GeneralConfig GENERAL_CONFIG = GeneralConfig.getInstance();
    static final Map<Class<? extends IMangedChunkData>, Supplier<IMangedChunkData>> MANAGED_SUBCLASSES = new ConcurrentHashMap<Class<? extends IMangedChunkData>, Supplier<IMangedChunkData>>();
    static final Map<class_1936, Map<String, ManagedChunk>> LOADED_CHUNKS = new ConcurrentHashMap<class_1936, Map<String, ManagedChunk>>();
    static final Map<class_1936, Set<String>> INITIALIZED_CHUNKS = new ConcurrentHashMap<class_1936, Set<String>>();
    private String id;
    private class_1936 level;
    private class_1923 pos;
    class_2791 levelChunk;
    private long tickWritten;
    private long tickLoaded;
    private boolean isLoaded;
    private final HashMap<Class<? extends IMangedChunkData>, IMangedChunkData> managedChunkData = new HashMap();
    public ManagedChunkUtility util = null;

    private ManagedChunk() {
    }

    public ManagedChunk(class_2487 tag) {
        this();
        this.deserializeNBT(tag);
        this.pos = HBUtil.ChunkUtil.getChunkPos(this.id);
        this.util = ManagedChunkUtility.getInstance(this.level);
        LOADED_CHUNKS.get(this.level).put(this.id, this);
    }

    public ManagedChunk(class_1936 level, class_1923 pos) {
        this();
        this.id = HBUtil.ChunkUtil.getId(pos);
        this.pos = pos;
        this.level = level;
        this.util = ManagedChunkUtility.getInstance(level);
        if (!this.level.method_8608()) {
            this.tickLoaded = GENERAL_CONFIG.getTotalTickCount();
            this.initSubclassesFromMemory(level, this.id);
        }
        LOADED_CHUNKS.putIfAbsent(this.level, new ConcurrentHashMap());
        INITIALIZED_CHUNKS.putIfAbsent(this.level, new ConcurrentSet());
        LOADED_CHUNKS.get(this.level).put(this.id, this);
        INITIALIZED_CHUNKS.get(this.level).add(this.id);
    }

    public IMangedChunkData getSubclass(Class<? extends IMangedChunkData> classObject) {
        return this.managedChunkData.get(classObject);
    }

    public String getId() {
        return this.id;
    }

    public class_1936 getLevel() {
        return this.level;
    }

    public class_1923 getChunkPos() {
        if (this.pos == null) {
            this.pos = HBUtil.ChunkUtil.getChunkPos(this.id);
        }
        return this.pos;
    }

    public class_2338 getWorldPos() {
        return HBUtil.ChunkUtil.getWorldPos(this.id);
    }

    public class_2818 getCachedLevelChunk() {
        if (this.levelChunk instanceof class_2818) {
            return (class_2818)this.levelChunk;
        }
        return null;
    }

    public class_2818 getLevelChunk() {
        if (this.levelChunk instanceof class_2818) {
            return (class_2818)this.levelChunk;
        }
        if (this.util.isChunkFullyLoaded(this.id)) {
            if (this.level.method_8608()) {
                return (class_2818)this.level.method_8392(this.pos.field_9181, this.pos.field_9180);
            }
            class_2791 c = this.level.method_8392(this.pos.field_9181, this.pos.field_9180);
            if (c instanceof class_2818) {
                this.levelChunk = c;
            }
            return (class_2818)this.levelChunk;
        }
        return null;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setLevel(class_1936 level) {
        this.level = level;
    }

    void releaseLevelChunk() {
        this.levelChunk = null;
    }

    public Boolean setSubclass(Class<? extends IMangedChunkData> classObject, IMangedChunkData data) {
        if (classObject == null || data == null) {
            return false;
        }
        this.managedChunkData.put(classObject, data);
        return true;
    }

    private void initSubclassesFromMemory(class_1936 level, String chunkId) {
        for (Map.Entry<Class<? extends IMangedChunkData>, Supplier<IMangedChunkData>> data : MANAGED_SUBCLASSES.entrySet()) {
            this.setSubclass(data.getKey(), data.getValue().get().getStaticInstance(level, chunkId));
        }
    }

    private void initSubclassesFromNbt(class_2487 tag) throws InvalidId {
        HashMap<String, String> errors = new HashMap<String, String>();
        for (Map.Entry<Class<? extends IMangedChunkData>, Supplier<IMangedChunkData>> data : MANAGED_SUBCLASSES.entrySet()) {
            IMangedChunkData sub = data.getValue().get();
            try {
                class_2487 nbt = tag.method_10562(sub.getClass().getName());
                sub.setId(this.id);
                sub.setLevel(this.level);
                if (this.managedChunkData.containsKey(sub.getClass())) {
                    this.managedChunkData.get(sub.getClass()).deserializeNBT(nbt);
                    continue;
                }
                sub.deserializeNBT(nbt);
                this.setSubclass(sub.getClass(), sub);
            }
            catch (Exception e) {
                errors.put(sub.getClass().getName(), e.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder error = new StringBuilder();
            for (String key : errors.keySet()) {
                error.append(key).append(": ").append((String)errors.get(key)).append("\n");
            }
            throw new InvalidId(error.toString());
        }
    }

    private void init(class_2487 tag) throws InvalidId {
        this.id = tag.method_10558("id");
        this.level = HBUtil.LevelUtil.toLevel(HBUtil.LevelUtil.LevelNameSpace.SERVER, tag.method_10558("level"));
        this.tickWritten = tag.method_10537("tickWritten");
        if (this.isLoaded) {
            this.initSubclassesFromMemory(this.level, this.id);
        } else {
            this.initSubclassesFromNbt(tag);
        }
        this.tickLoaded = GENERAL_CONFIG.getTotalTickCount();
    }

    @Override
    public boolean isInit(String subClass) {
        for (IMangedChunkData data : this.managedChunkData.values()) {
            if (!data.getClass().getName().equals(subClass)) continue;
            return data.isInit(subClass);
        }
        return false;
    }

    @Override
    public IMangedChunkData getStaticInstance(class_1936 level, String id) {
        return ManagedChunkUtility.getInstance(level).getManagedChunk(id);
    }

    @Override
    public void handleChunkLoaded(ChunkLoadingEvent.Load event) {
        this.isLoaded = true;
        if (this.level.method_8608()) {
            return;
        }
        this.levelChunk = event.getChunk();
        for (IMangedChunkData data : this.managedChunkData.values()) {
            data.handleChunkLoaded(event);
        }
    }

    @Override
    public void handleChunkUnloaded(ChunkLoadingEvent.Unload event) {
        this.isLoaded = false;
        if (this.level.method_8608()) {
            return;
        }
        this.levelChunk = null;
        for (IMangedChunkData data : this.managedChunkData.values()) {
            data.handleChunkUnloaded(event);
        }
    }

    public static void init(EventRegistrar reg) {
        ManagedChunkUtility.init(reg);
        ManagedChunkEvents.init(reg);
        ManagedChunkBlockUpdates.init(reg);
    }

    public static boolean updateChunkBlockStates(class_1936 level, Map<class_2680, List<class_2338>> updates) {
        return ManagedChunkBlockUpdates.updateChunkBlocks(level, updates);
    }

    public static boolean updateChunkBlocks(class_1936 level, List<Pair<class_2248, class_2338>> updates) {
        return ManagedChunkBlockUpdates.updateChunkBlocks(level, updates);
    }

    public static boolean updateChunkBlockStates(class_1936 level, List<Pair<class_2680, class_2338>> updates) {
        return ManagedChunkBlockUpdates.updateChunkBlockStates(level, updates);
    }

    public static boolean checkUpdateBlockStateSucceeded(class_1936 level, Pair<class_2680, class_2338> update) {
        return ManagedChunkBlockUpdates.checkUpdateBlockStateSucceeded(level, update);
    }

    public static void registerManagedChunkData(Class<? extends IMangedChunkData> classObject, Supplier<IMangedChunkData> data) {
        MANAGED_SUBCLASSES.put(classObject, data);
    }

    static void save(DatastoreSaveEvent event, class_1936 level) {
        DataStore ds = event.getDataStore();
        LevelSaveData levelData = ds.getOrCreateLevelSaveData("hbs_foundation", level);
        Set<String> initChunks = INITIALIZED_CHUNKS.get(level);
        if (initChunks == null) {
            return;
        }
        String[] chunkIds = initChunks.toArray(new String[0]);
        levelData.addProperty("initializedChunkIds", HBUtil.FileIO.arrayToJson(chunkIds));
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 details = new class_2487();
        if (this.id == null || this.level == null) {
            LoggerBase.logError(null, "003004", "ManagedChunk not initialized with id or level and cannot be serialized");
            return details;
        }
        int count = 0;
        try {
            details.method_10582("id", this.id);
            ++count;
            details.method_10582("level", HBUtil.LevelUtil.toLevelId(this.level));
            ++count;
            this.tickWritten = GENERAL_CONFIG.getTotalTickCount();
            ++count;
            details.method_10544("tickWritten", this.tickWritten);
            ++count;
            for (IMangedChunkData data : this.managedChunkData.values()) {
                if (data == null) continue;
                details.method_10566(data.getClass().getName(), (class_2520)data.serializeNBT());
                ++count;
            }
        }
        catch (Exception e) {
            StringBuilder error = new StringBuilder();
            error.append("Error serializing ManagedChunk with id: ");
            error.append(this.id);
            error.append("\nError: ");
            error.append(e.getClass());
            error.append(" - ");
            error.append(e.getMessage());
            error.append("\nCount: ");
            error.append(count);
            LoggerBase.logError(null, "003020", error.toString());
        }
        return details;
    }

    @Override
    public void deserializeNBT(class_2487 tag) {
        if (tag == null || tag.method_33133()) {
            return;
        }
        try {
            this.init(tag);
        }
        catch (InvalidId e) {
            LoggerBase.logError(null, "003021", "Error initializing ManagedChunk with id: " + this.id);
        }
    }
}

