/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.model;

import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.LoggerBase;
import com.holybuckets.foundation.block.ModBlocks;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.model.ManagedChunkUtility;
import com.holybuckets.foundation.networking.BlockStateUpdatesMessage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.apache.commons.lang3.tuple.Pair;

public class ManagedChunkBlockUpdates {
    private static final String CLASS_ID = "013";
    private static final int MAX_ATTEMPTS = 5;
    private final ManagedChunkUtility util;
    private class_1936 level;
    private Queue<Pair<class_2680, class_2338>> UPDATES;
    private Iterator<Pair<class_2680, class_2338>> NEXT_UPDATE;
    private Map<Integer, Integer> PENDING;
    private Map<Integer, WeakReference<Pair<class_2680, class_2338>>> SUCCEEDED;
    private WriteMonitor writeMonitor;
    static final Map<class_1936, ManagedChunkBlockUpdates> LEVEL_UPDATES = new ConcurrentHashMap<class_1936, ManagedChunkBlockUpdates>();

    public ManagedChunkBlockUpdates(class_1936 level) {
        this.level = level;
        this.util = ManagedChunkUtility.getInstance(level);
        this.PENDING = new ConcurrentHashMap<Integer, Integer>();
        this.UPDATES = new ConcurrentLinkedQueue<Pair<class_2680, class_2338>>();
        this.SUCCEEDED = new ConcurrentHashMap<Integer, WeakReference<Pair<class_2680, class_2338>>>();
        this.writeMonitor = new WriteMonitor();
    }

    private void addUpdate(Pair<class_2680, class_2338> update) {
        if (update == null || this.PENDING.containsKey(update.hashCode())) {
            return;
        }
        this.PENDING.put(update.hashCode(), 0);
        this.UPDATES.add(update);
    }

    boolean checkSucceeded(int hashCode) {
        return this.SUCCEEDED.remove(hashCode) != null;
    }

    private void clear() {
        this.PENDING.clear();
        this.UPDATES.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBlockStates() {
        try {
            if (!this.writeMonitor.tryLockMainThread()) {
                return;
            }
            if (this.UPDATES.isEmpty()) {
                return;
            }
            if (this.NEXT_UPDATE == null || !this.NEXT_UPDATE.hasNext()) {
                this.NEXT_UPDATE = this.UPDATES.iterator();
                if (!this.NEXT_UPDATE.hasNext()) {
                    return;
                }
            }
            int writesPerTick = this.writeMonitor.getWritePerTick();
            for (int i = 0; i < writesPerTick && this.NEXT_UPDATE.hasNext(); ++i) {
                Pair<class_2680, class_2338> update = this.NEXT_UPDATE.next();
                if (update == null) continue;
                int q = 0;
                q = this.level.method_8608() ? 1 : 2;
                if (this.updateBlockState(update)) {
                    this.SUCCEEDED.put(update.hashCode(), new WeakReference<Pair<class_2680, class_2338>>(update));
                    this.PENDING.remove(update.hashCode());
                    this.NEXT_UPDATE.remove();
                    continue;
                }
                if (this.PENDING.get(update.hashCode()) < 5) {
                    this.PENDING.put(update.hashCode(), this.PENDING.get(update.hashCode()) + 1);
                    --i;
                    continue;
                }
                this.PENDING.remove(update.hashCode());
                this.NEXT_UPDATE.remove();
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.writeMonitor.unlock();
        }
    }

    private void shutdown() {
        if (this.writeMonitor != null) {
            // empty if block
        }
    }

    private boolean updateBlockState(Pair<class_2680, class_2338> update) {
        int tag;
        class_2680 state = (class_2680)update.getLeft();
        class_2338 pos = (class_2338)update.getRight();
        boolean succeeded = this.level.method_8652(pos, state, tag = 8);
        if (succeeded) {
            this.level.method_22350(pos).method_12008(true);
        }
        return succeeded;
    }

    private boolean ableToUpdateBlock(Pair<class_2680, class_2338> update) {
        return this.util.isChunkFullyLoaded((class_2338)update.getRight());
    }

    static boolean updateChunkBlocks(class_1936 level, Map<class_2680, List<class_2338>> updates) {
        LinkedList<Pair<class_2680, class_2338>> blockStates = new LinkedList<Pair<class_2680, class_2338>>();
        for (Map.Entry<class_2680, List<class_2338>> update : updates.entrySet()) {
            for (class_2338 pos : update.getValue()) {
                blockStates.add((Pair<class_2680, class_2338>)Pair.of((Object)update.getKey(), (Object)pos));
            }
        }
        return ManagedChunkBlockUpdates.updateChunkBlockStates(level, blockStates);
    }

    static boolean updateChunkBlocks(class_1936 level, List<Pair<class_2248, class_2338>> updates) {
        LinkedList<Pair<class_2680, class_2338>> blockStates = new LinkedList<Pair<class_2680, class_2338>>();
        for (Pair<class_2248, class_2338> update : updates) {
            blockStates.add((Pair<class_2680, class_2338>)Pair.of((Object)((class_2248)update.getLeft()).method_9564(), (Object)((class_2338)update.getRight())));
        }
        return ManagedChunkBlockUpdates.updateChunkBlockStates(level, blockStates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized boolean updateChunkBlockStates(class_1936 level, List<Pair<class_2680, class_2338>> updates) {
        if (updates == null || updates.isEmpty()) {
            return false;
        }
        ManagedChunkBlockUpdates manager = LEVEL_UPDATES.get(level);
        if (manager == null) {
            return false;
        }
        ArrayList<Pair<class_2680, class_2338>> mutableUpdates = new ArrayList<Pair<class_2680, class_2338>>(updates);
        mutableUpdates.removeIf(p -> ((class_2680)p.getLeft()).equals(ModBlocks.empty.method_9564()));
        if (!level.method_8608() && mutableUpdates.stream().anyMatch(p -> !manager.ableToUpdateBlock((Pair<class_2680, class_2338>)p))) {
            return false;
        }
        try {
            if (!manager.writeMonitor.tryLockWorkerThread()) {
                boolean bl = false;
                return bl;
            }
            mutableUpdates.forEach(manager::addUpdate);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            manager.writeMonitor.unlock();
        }
        if (!level.method_8608()) {
            return ManagedChunkBlockUpdates.sendChunkBlockStatesToClient(level, mutableUpdates);
        }
        return true;
    }

    static boolean sendChunkBlockStatesToClient(class_1936 level, List<Pair<class_2680, class_2338>> updates) {
        try {
            Map<class_2680, List<class_2338>> blockStateData = HBUtil.BlockUtil.condenseBlockStates(updates);
            BlockStateUpdatesMessage.createAndFire(level, blockStateData);
        }
        catch (Exception e) {
            LoggerBase.logError(null, "013001", "Failed to send block state updates to client");
            return false;
        }
        return true;
    }

    static boolean checkUpdateBlockStateSucceeded(class_1936 level, Pair<class_2680, class_2338> update) {
        ManagedChunkBlockUpdates manager = LEVEL_UPDATES.get(level);
        if (manager == null) {
            return false;
        }
        return manager.checkSucceeded(update.hashCode());
    }

    static void init(EventRegistrar registrar) {
        registrar.registerOnLevelLoad(ManagedChunkBlockUpdates::onLoadWorld);
        registrar.registerOnLevelUnload(ManagedChunkBlockUpdates::onUnloadWorld);
    }

    private static void onLoadWorld(LevelLoadingEvent.Load event) {
        LEVEL_UPDATES.put(event.getLevel(), new ManagedChunkBlockUpdates(event.getLevel()));
    }

    private static void onUnloadWorld(LevelLoadingEvent.Unload event) {
        ManagedChunkBlockUpdates manager = LEVEL_UPDATES.remove(event.getLevel());
        if (manager == null) {
            return;
        }
        manager.shutdown();
        manager.clear();
    }

    static void onWorldTick(class_1937 level) {
        ManagedChunkBlockUpdates manager = LEVEL_UPDATES.get(level);
        if (manager == null) {
            return;
        }
        manager.updateBlockStates();
    }

    private class WriteMonitor {
        private static int TICKS_PER_SECOND = 20;
        private AtomicInteger writesPerTick;
        private final int MODULO_COUNT = 4;
        private volatile int tickCount;
        private volatile Thread currentWorker;
        private Thread currentMain;
        final ReentrantLock lock = new ReentrantLock(false);

        public WriteMonitor() {
            GeneralConfig config = GeneralConfig.getInstance();
            this.writesPerTick = config.getPerformanceImpactConfig().getBlockWritesPerTick();
            this.tickCount = 0;
        }

        Integer getWritePerTick() {
            return this.writesPerTick.get() * 4;
        }

        boolean tryLockMainThread() {
            this.currentMain = Thread.currentThread();
            if (this.canWrite()) {
                return this.lock.tryLock();
            }
            return false;
        }

        boolean tryLockWorkerThread() {
            this.currentWorker = Thread.currentThread();
            if (this.softLock() || this.lock.isLocked()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return this.lock.tryLock();
        }

        private boolean canWrite() {
            if (this.tickCount % 4 == 0) {
                ++this.tickCount;
                return true;
            }
            ++this.tickCount;
            return false;
        }

        private boolean softLock() {
            return this.tickCount % 4 == 0;
        }

        public synchronized void unlock() {
            if (this.lock.isLocked() && this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }

        private void shutdown() {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.currentWorker != null && this.currentWorker.isAlive()) {
                this.currentWorker.interrupt();
            }
        }
    }
}

