/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.model;

import com.holybuckets.foundation.GeneralConfig;
import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.event.EventRegistrar;
import com.holybuckets.foundation.event.custom.ServerTickEvent;
import com.holybuckets.foundation.model.ManagedChunk;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LevelLoadingEvent;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2818;

public class ManagedChunkUtility {
    static final Map<class_1937, ManagedChunkUtility> INSTANCES = new ConcurrentHashMap<class_1937, ManagedChunkUtility>();
    final class_1936 level;
    private Thread cullLevelChunksThread;

    private ManagedChunkUtility(class_1936 level) {
        this.level = level;
    }

    public static ManagedChunkUtility getInstance(class_1936 level) {
        if (!(level instanceof class_1937)) {
            return null;
        }
        return INSTANCES.computeIfAbsent((class_1937)level, k -> new ManagedChunkUtility(level));
    }

    public static void init(EventRegistrar reg) {
        reg.registerOnLevelLoad(ManagedChunkUtility::onWorldLoad, EventPriority.High);
        reg.registerOnLevelUnload(ManagedChunkUtility::onWorldUnload, EventPriority.Low);
    }

    public boolean isLoaded(String id) {
        if (id == null) {
            return false;
        }
        if (ManagedChunk.LOADED_CHUNKS.get(this.level) == null) {
            return false;
        }
        ManagedChunk mc = ManagedChunk.LOADED_CHUNKS.get(this.level).get(id);
        return mc != null;
    }

    public boolean isLoaded(class_2338 p) {
        class_1937 levelType = (class_1937)this.level;
        return levelType.method_8477(p) && this.isLoaded(levelType.method_22350(p));
    }

    public boolean isLoaded(class_2791 c) {
        if (c == null) {
            return false;
        }
        return this.isLoaded(c.method_12004());
    }

    public boolean isLoaded(class_1923 p) {
        return this.isLoaded(HBUtil.ChunkUtil.getId(p));
    }

    public boolean isChunkFullyLoaded(class_1923 cp) {
        if (!this.isLoaded(cp)) {
            return false;
        }
        List<String> localAreaChunks = HBUtil.ChunkUtil.getLocalChunkIds(cp, 1);
        return localAreaChunks.stream().allMatch(this::isLoaded);
    }

    public boolean isChunkFullyLoaded(String id) {
        return this.isChunkFullyLoaded(HBUtil.ChunkUtil.getChunkPos(id));
    }

    public boolean isChunkFullyLoaded(class_2338 pos) {
        return this.isChunkFullyLoaded(HBUtil.ChunkUtil.getChunkPos(pos));
    }

    @Nullable
    public Set<String> getInitializedChunks() {
        if (ManagedChunk.INITIALIZED_CHUNKS.get(this.level) == null) {
            return null;
        }
        return ManagedChunk.INITIALIZED_CHUNKS.get(this.level).stream().collect(Collectors.toSet());
    }

    public class_2818 getChunk(String chunkId, boolean forceLoad) {
        if (chunkId == null) {
            return null;
        }
        if (ManagedChunk.LOADED_CHUNKS.get(this.level) == null) {
            return null;
        }
        if (!ManagedChunk.LOADED_CHUNKS.get(this.level).containsKey(chunkId)) {
            return null;
        }
        return ManagedChunk.LOADED_CHUNKS.get(this.level).get(chunkId).getLevelChunk();
    }

    public ManagedChunk getManagedChunk(String id) {
        if (id == null) {
            return null;
        }
        if (ManagedChunk.LOADED_CHUNKS.get(this.level) == null) {
            return null;
        }
        return ManagedChunk.LOADED_CHUNKS.get(this.level).get(id);
    }

    public static ManagedChunk getManagedChunk(class_1936 level, String id) {
        if (id == null || level == null) {
            return null;
        }
        if (ManagedChunk.LOADED_CHUNKS.get(level) == null) {
            return null;
        }
        return ManagedChunk.LOADED_CHUNKS.get(level).get(id);
    }

    public static Random getChunkRandom(class_1923 pos) {
        GeneralConfig CONFIG = GeneralConfig.getInstance();
        return ManagedChunkUtility.getChunkRandom(pos, CONFIG.getWorldSeed());
    }

    public static Random getChunkRandom(class_1923 pos, Long SEED) {
        Double RAND = (double)HBUtil.ChunkUtil.getChunkPos1DMap(pos).longValue() * 1.0;
        if (RAND.equals(0.0)) {
            return new Random(SEED);
        }
        RAND = (double)SEED.longValue() / RAND;
        if (RAND < 1.0 && RAND > -1.0) {
            RAND = 1.0 / RAND;
        }
        return new Random(RAND.intValue());
    }

    void cullLevelChunks(ServerTickEvent event) {
        if (this.cullLevelChunksThread != null) {
            this.cullLevelChunksThread.interrupt();
        }
        this.cullLevelChunksThread = new Thread(this::cullLevelChunks);
        this.cullLevelChunksThread.start();
    }

    private void cullLevelChunks() {
        if (ManagedChunk.LOADED_CHUNKS.get(this.level) == null) {
            return;
        }
        Map<String, ManagedChunk> loadedChunks = ManagedChunk.LOADED_CHUNKS.get(this.level);
        boolean cull = loadedChunks.size() > 16000;
        for (ManagedChunk m : loadedChunks.values()) {
            boolean hasLevelChunk;
            boolean isFullyLoaded = m.util.isChunkFullyLoaded(m.getChunkPos());
            boolean bl = hasLevelChunk = m.getLevelChunk() != null;
            if (isFullyLoaded && hasLevelChunk) {
                boolean bl2 = false;
                continue;
            }
            if (!isFullyLoaded && !hasLevelChunk) {
                boolean bl3 = false;
                continue;
            }
            if (!isFullyLoaded && hasLevelChunk && cull) {
                m.releaseLevelChunk();
                continue;
            }
            if (!isFullyLoaded && hasLevelChunk && !cull) {
                List<String> localChunks = HBUtil.ChunkUtil.getLocalChunkIds(m.getChunkPos(), 1);
                long countLoaded = localChunks.stream().filter(s -> m.util.isLoaded((String)s)).count();
                if (countLoaded != 0L) continue;
                m.releaseLevelChunk();
                continue;
            }
            if (!isFullyLoaded || hasLevelChunk) continue;
            class_1923 cp = m.getChunkPos();
            m.levelChunk = HBUtil.ChunkUtil.getLevelChunk(this.level, cp.field_9181, cp.field_9180, false);
        }
    }

    private void shutdown() {
        if (this.cullLevelChunksThread != null) {
            this.cullLevelChunksThread.interrupt();
            this.cullLevelChunksThread = null;
        }
    }

    public static void onWorldLoad(LevelLoadingEvent.Load event) {
        ManagedChunkUtility.getInstance(event.getLevel());
    }

    public static void onWorldUnload(LevelLoadingEvent.Unload event) {
        ManagedChunkUtility util = INSTANCES.remove(event.getLevel());
        if (util != null) {
            util.shutdown();
        }
    }
}

