/*
 * Decompiled with CFR 0.152.
 */
package com.holybuckets.foundation.networking;

import com.holybuckets.foundation.HBUtil;
import com.holybuckets.foundation.model.ManagedChunk;
import com.holybuckets.foundation.networking.BlockStateUpdatesMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateUpdatesMessageHandler {
    private static HashSet<Integer> collisionChecker = new HashSet();

    static void createAndFire(class_1936 world, Map<class_2680, List<class_2338>> updates) {
        ArrayList messages = new ArrayList();
        LinkedList<Pair> iterators = new LinkedList<Pair>();
        for (Map.Entry<class_2680, List<class_2338>> entry : updates.entrySet()) {
            if (entry.getValue().size() == 0) continue;
            iterators.add(Pair.of((Object)entry.getKey(), entry.getValue().listIterator()));
        }
        int MAX_SIZE = 512;
        Pair current = (Pair)iterators.poll();
        while (current != null) {
            HashMap blockStateUpdates = new HashMap();
            for (int i = 0; i < 512; ++i) {
                if (!((Iterator)current.getRight()).hasNext()) {
                    current = (Pair)iterators.poll();
                }
                if (current == null) break;
                blockStateUpdates.putIfAbsent((class_2680)current.getLeft(), new ArrayList());
                List positions = (List)blockStateUpdates.get(current.getLeft());
                positions.add((class_2338)((Iterator)current.getRight()).next());
            }
            if (blockStateUpdates.size() <= 0) continue;
            messages.add(blockStateUpdates);
        }
        class_2338 pos = updates.values().stream().findFirst().get().get(0);
        int CHUNKS_RANGE = 40;
        List<class_3222> playersInUpdateRange = HBUtil.PlayerUtil.getAllPlayersInBlockRange(pos, 640);
        for (Map map : messages) {
            BlockStateUpdatesMessage packet = new BlockStateUpdatesMessage(world, map);
            playersInUpdateRange.stream().forEach(player -> HBUtil.NetworkUtil.serverSendToPlayer((class_1657)player, packet));
        }
    }

    static void handle(class_1657 player, BlockStateUpdatesMessage message) {
        if (player.method_37908() != message.world) {
            return;
        }
        ManagedChunk.updateChunkBlockStates(message.world, message.blockStates);
    }
}

