/*
 * Decompiled with CFR 0.152.
 */
package fr.Nat0uille.NatMOTD.Listeners;

import fr.Nat0uille.NatMOTD.Main;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MOTDListener
implements Listener {
    public Main Main;
    MiniMessage mm = MiniMessage.miniMessage();

    public MOTDListener(Main Main2) {
        this.Main = Main2;
    }

    @EventHandler
    public void onPlayerJoin(final PlayerJoinEvent event) {
        new BukkitRunnable(){

            public void run() {
                if (event.getPlayer().hasPermission("natwhitelist.admin") && MOTDListener.this.Main.getCheckVersion().outdated()) {
                    event.getPlayer().sendMessage(MOTDListener.this.mm.deserialize((Object)(MOTDListener.this.Main.getConfig().getString("messages.prefix") + MOTDListener.this.Main.getConfig().getString("messages.outdated").replace("{latest}", MOTDListener.this.Main.getCheckVersion().getRemoteVersion()).replace("{local}", MOTDListener.this.Main.getCheckVersion().getLocalVersion()))));
                }
            }
        }.runTaskLater((Plugin)this.Main, 20L);
    }

    @EventHandler
    public void onServerListPing(ServerListPingEvent event) {
        MiniMessage mm = MiniMessage.miniMessage();
        int selected = this.Main.getConfig().getInt("motd.selected", 1);
        String pathPrefix = "motd." + selected + ".";
        String rawLine1 = this.Main.getConfig().getString(pathPrefix + "line1.text");
        String rawLine2 = this.Main.getConfig().getString(pathPrefix + "line2.text");
        boolean center1 = this.Main.getConfig().getBoolean(pathPrefix + "line1.center");
        boolean center2 = this.Main.getConfig().getBoolean(pathPrefix + "line2.center");
        int playersMax = this.Main.getConfig().getInt(pathPrefix + "players-max", 0);
        Component comp1 = mm.deserialize((Object)rawLine1);
        Component comp2 = mm.deserialize((Object)rawLine2);
        String legacy1 = LegacyComponentSerializer.legacySection().serialize(comp1);
        String legacy2 = LegacyComponentSerializer.legacySection().serialize(comp2);
        if (center1) {
            legacy1 = MOTDListener.centerMotd(legacy1);
        }
        if (center2) {
            legacy2 = MOTDListener.centerMotd(legacy2);
        }
        TextComponent final1 = LegacyComponentSerializer.legacySection().deserialize(legacy1);
        TextComponent final2 = LegacyComponentSerializer.legacySection().deserialize(legacy2);
        Component motd = final1.append((Component)Component.newline()).append((Component)final2);
        event.motd(motd);
        event.setMaxPlayers(playersMax);
    }

    public static String centerMotd(String message) {
        if (message == null || message.equals("")) {
            return "";
        }
        int CENTER_PX = 130;
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                if (c == 'l' || c == 'L') {
                    isBold = true;
                    continue;
                }
                isBold = false;
                continue;
            }
            int charPx = MOTDListener.getDefaultCharWidth(c);
            messagePxSize += isBold ? charPx + 1 : charPx;
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = CENTER_PX - halvedMessageSize;
        int spaceWidth = MOTDListener.getDefaultCharWidth(' ');
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceWidth) {
            sb.append(" ");
        }
        return String.valueOf(sb) + message;
    }

    public static int getDefaultCharWidth(char c) {
        switch (c) {
            case '!': 
            case ',': 
            case '.': 
            case 'i': 
            case 'l': 
            case '|': {
                return 2;
            }
            case '\'': {
                return 3;
            }
            case ' ': {
                return 4;
            }
            case 'I': 
            case '[': 
            case ']': 
            case 't': {
                return 4;
            }
            case '<': 
            case '>': 
            case 'k': 
            case '{': 
            case '}': {
                return 5;
            }
        }
        return 6;
    }
}

