/*
 * Decompiled with CFR 0.152.
 */
package net.ethyl.lattice_api.core.data;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.ethyl.lattice_api.core.data.LatticeRegistries;
import net.ethyl.lattice_api.modules.base.LatticeBlock;
import net.ethyl.lattice_api.modules.base.LatticeItem;
import net.ethyl.lattice_api.modules.base.LatticeObject;
import net.ethyl.lattice_api.modules.base.LatticeTag;
import net.ethyl.lattice_api.modules.common.blocks.LatticeBasicBlock;
import net.ethyl.lattice_api.modules.common.blocks.LatticeSlabBlock;
import net.ethyl.lattice_api.modules.common.blocks.LatticeStairBlock;
import net.ethyl.lattice_api.modules.common.tags.LatticeBlockTag;
import net.ethyl.lattice_api.modules.common.tags.LatticeItemTag;
import net.ethyl.lattice_api.modules.common.types.modelTypes.LatticeBlockModelType;
import net.ethyl.lattice_api.modules.common.types.modelTypes.LatticeItemModelType;
import net.ethyl.lattice_api.modules.common.types.other.LatticeLootTable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatticeDataGen {
    public static void onGatherDataEvent(GatherDataEvent event, String modId) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        BlockTagGenerator blockTagsProvider = new BlockTagGenerator(packOutput, lookupProvider, modId, existingFileHelper);
        dataGenerator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), modId, existingFileHelper));
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ignored -> new BlockLootTableProvider((HolderLookup.Provider)lookupProvider.join(), modId), LootContextParamSets.BLOCK)), lookupProvider));
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(packOutput, modId, existingFileHelper));
        dataGenerator.addProvider(event.includeClient(), (DataProvider)new BlockModelGenerator(packOutput, modId, existingFileHelper));
    }

    public static void addListeners(@NotNull IEventBus modEventBus, @NotNull String modId) {
        modEventBus.addListener(event -> LatticeDataGen.onGatherDataEvent(event, modId));
    }

    public static <I extends LatticeObject> boolean isNotFromMod(@NotNull I latticeObject, @NotNull String modId) {
        return !latticeObject.getModId().equals(modId);
    }

    public static class BlockTagGenerator
    extends BlockTagsProvider {
        public BlockTagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, modId, existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            for (LatticeTag<?> latticeTag : LatticeRegistries.getTags()) {
                if (LatticeDataGen.isNotFromMod(latticeTag, this.modId) || !(latticeTag instanceof LatticeBlockTag)) continue;
                LatticeBlockTag latticeBlockTag = (LatticeBlockTag)latticeTag;
                IntrinsicHolderTagsProvider.IntrinsicTagAppender tagAppender = this.tag(latticeBlockTag.get());
                latticeBlockTag.getTagContent().forEach(blockSupplier -> tagAppender.add((Object)((Block)blockSupplier.get())));
            }
        }
    }

    public static class ItemTagGenerator
    extends ItemTagsProvider {
        public ItemTagGenerator(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, lookupProvider, blockTags, modId, existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            for (LatticeTag<?> latticeTag : LatticeRegistries.getTags()) {
                if (LatticeDataGen.isNotFromMod(latticeTag, this.modId) || !(latticeTag instanceof LatticeItemTag)) continue;
                LatticeItemTag lItemTag = (LatticeItemTag)latticeTag;
                IntrinsicHolderTagsProvider.IntrinsicTagAppender tagAppender = this.tag(lItemTag.get());
                lItemTag.getTagContent().forEach(itemSupplier -> tagAppender.add((Object)((Item)itemSupplier.get())));
            }
        }
    }

    public static class ItemModelGenerator
    extends ItemModelProvider {
        public ItemModelGenerator(PackOutput output, String modId, ExistingFileHelper existingFileHelper) {
            super(output, modId, existingFileHelper);
        }

        protected void registerModels() {
            for (LatticeItem<?> latticeItem : LatticeRegistries.getItems()) {
                if (LatticeDataGen.isNotFromMod(latticeItem, this.modid)) continue;
                Object item = latticeItem.get();
                LatticeItemModelType modelType = latticeItem.getModelType();
                if (modelType == LatticeRegistries.Types.Item.BASIC) {
                    this.basicItem((Item)item);
                    continue;
                }
                if (modelType != LatticeRegistries.Types.Item.HANDHELD) continue;
                this.handheldItem((Item)item);
            }
        }
    }

    public static class BlockModelGenerator
    extends BlockStateProvider {
        private final String modId;

        public BlockModelGenerator(PackOutput packOutput, String modId, ExistingFileHelper existingFileHelper) {
            super(packOutput, modId, existingFileHelper);
            this.modId = modId;
        }

        protected void registerStatesAndModels() {
            for (LatticeBlock<?> latticeBlock : LatticeRegistries.getBlocks()) {
                if (LatticeDataGen.isNotFromMod(latticeBlock, this.modId)) continue;
                LatticeBlockModelType modelType = latticeBlock.getModelType();
                if (latticeBlock instanceof LatticeBasicBlock) {
                    LatticeBasicBlock latticeBasicBlock = (LatticeBasicBlock)latticeBlock;
                    Object block = latticeBasicBlock.get();
                    String path = this.getPath(latticeBlock);
                    if (modelType == LatticeRegistries.Types.Block.BASIC) {
                        this.simpleBlockWithItem((Block)block, this.cubeAll((Block)block));
                        continue;
                    }
                    if (modelType != LatticeRegistries.Types.Block.WITH_SIDES) continue;
                    this.simpleBlockWithItem((Block)block, (ModelFile)this.models().cubeColumn(path, this.getSide(latticeBlock), this.getBase(latticeBlock)));
                    continue;
                }
                if (latticeBlock instanceof LatticeStairBlock) {
                    LatticeStairBlock latticeStairBlock = (LatticeStairBlock)latticeBlock;
                    StairBlock stairBlock = (StairBlock)latticeStairBlock.get();
                    defaultBlock = latticeStairBlock.getDefaultBlock().get();
                    if (modelType == LatticeRegistries.Types.Block.BASIC) {
                        this.stairsBlock(stairBlock, this.blockTexture(latticeStairBlock.getDefaultBlock().get()));
                    } else if (modelType == LatticeRegistries.Types.Block.WITH_SIDES) {
                        this.stairsBlockWithRenderType(stairBlock, this.getSide(defaultBlock), this.getBase(defaultBlock), this.getBase(defaultBlock), "cutout");
                    }
                } else if (latticeBlock instanceof LatticeSlabBlock) {
                    LatticeSlabBlock latticeSlabBlock = (LatticeSlabBlock)latticeBlock;
                    SlabBlock slabBlock = (SlabBlock)latticeSlabBlock.get();
                    defaultBlock = latticeSlabBlock.getDefaultBlock().get();
                    if (modelType == LatticeRegistries.Types.Block.BASIC) {
                        this.slabBlock(slabBlock, this.getBase(defaultBlock), this.getBase(defaultBlock));
                    } else if (modelType == LatticeRegistries.Types.Block.WITH_SIDES) {
                        this.slabBlock(slabBlock, this.getBase(defaultBlock), this.getSlab(defaultBlock), this.getBase(defaultBlock), this.getBase(defaultBlock));
                    }
                }
                this.createBlockItem(latticeBlock);
            }
        }

        private String getPath(@NotNull LatticeBlock<?> latticeBlock) {
            return this.getPath((Block)latticeBlock.get());
        }

        private String getPath(@NotNull Block block) {
            return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        }

        private ResourceLocation getTexture(@NotNull Block block, @Nullable String extension) {
            return this.modLoc("block/" + this.getPath(block) + (String)(extension == null ? "" : "_" + extension));
        }

        private ResourceLocation getBase(@NotNull LatticeBlock<?> latticeBlock) {
            return this.getBase((Block)latticeBlock.get());
        }

        private ResourceLocation getBase(@NotNull Block block) {
            return this.getTexture(block, null);
        }

        private ResourceLocation getSide(@NotNull LatticeBlock<?> latticeBlock) {
            return this.getSide((Block)latticeBlock.get());
        }

        private ResourceLocation getSide(@NotNull Block block) {
            return this.getTexture(block, "side");
        }

        private ResourceLocation getTop(@NotNull LatticeBlock<?> latticeBlock) {
            return this.getTop((Block)latticeBlock.get());
        }

        private ResourceLocation getTop(@NotNull Block block) {
            return this.getTexture(block, "top");
        }

        private ResourceLocation getBottom(@NotNull LatticeBlock<?> latticeBlock) {
            return this.getBottom((Block)latticeBlock.get());
        }

        private ResourceLocation getBottom(@NotNull Block block) {
            return this.getTexture(block, "bottom");
        }

        private ResourceLocation getSlab(@NotNull Block block) {
            return this.getTexture(block, "slab");
        }

        private void createBlockItem(@NotNull LatticeBlock<?> latticeBlock) {
            this.simpleBlockItem((Block)latticeBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile(latticeBlock.getModId() + ":block/" + this.getPath(latticeBlock)));
        }
    }

    public static class BlockLootTableProvider
    extends BlockLootSubProvider {
        private final String modId;

        protected BlockLootTableProvider(HolderLookup.Provider registries, @NotNull String modId) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
            this.modId = modId;
        }

        protected void generate() {
            for (LatticeBlock<?> latticeBlock : LatticeRegistries.getBlocks()) {
                if (LatticeDataGen.isNotFromMod(latticeBlock, this.modId)) continue;
                LatticeLootTable lootType = latticeBlock.getLootType();
                Object block = latticeBlock.get();
                if (lootType == LatticeRegistries.Types.LootTable.SELF) {
                    this.dropSelf((Block)block);
                    continue;
                }
                if (lootType == LatticeRegistries.Types.LootTable.SILK_TOUCH) {
                    this.dropWhenSilkTouch((Block)block);
                    continue;
                }
                if (lootType == LatticeRegistries.Types.LootTable.OTHER) {
                    this.dropOther((Block)block, (ItemLike)lootType.drop.get());
                    continue;
                }
                if (lootType != LatticeRegistries.Types.LootTable.AMOUNT) continue;
                this.add((Block)block, sBlock -> this.createAmountDrops((Block)sBlock, lootType.drop.get(), lootType.minDrops, lootType.maxDrops));
            }
        }

        private LootTable.Builder createAmountDrops(Block block, Item item, float minDrops, float maxDrops) {
            HolderLookup.RegistryLookup registryLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minDrops, (float)maxDrops))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registryLookup.getOrThrow(Enchantments.FORTUNE)))));
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return LatticeRegistries.getBlocks().stream().filter(latticeBlock -> !LatticeDataGen.isNotFromMod(latticeBlock, this.modId)).map(latticeBlock -> latticeBlock.get()).toList();
        }
    }
}

