/*
 * Decompiled with CFR 0.152.
 */
package net.ethyl.lattice_api.core.utils;

import java.util.Collection;
import net.ethyl.lattice_api.LatticeApi;
import net.ethyl.lattice_api.core.instances.RegistryId;
import net.ethyl.lattice_api.modules.base.LatticeObject;
import net.ethyl.lattice_api.modules.common.tabs.LatticeCreativeTab;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class RegistryUtils {
    public static void checkDuplicate(@NotNull Collection<? extends LatticeObject> collection, @NotNull RegistryId registryId) {
        if (collection.stream().anyMatch(latticeObject -> latticeObject.getRegistryId().toString().equals(registryId.toString()))) {
            LatticeApi.duplicateObjectErr(registryId);
        }
    }

    public static CreativeModeTab createTab(@NotNull LatticeCreativeTab.AppendableBuilder<? extends LatticeCreativeTab, ?> builder, @NotNull RegistryId registryId) {
        return CreativeModeTab.builder().title((Component)Component.translatable((String)("tab." + registryId.getNamespace() + "." + registryId.getPath()))).icon(builder.icon).displayItems((itemDisplayParameters, output) -> builder.tabContent.forEach(itemLikeSupplier -> output.accept((ItemLike)itemLikeSupplier.get()))).build();
    }
}

