/*
 * Decompiled with CFR 0.152.
 */
package net.ethyl.lattice_api.modules.common.blocks;

import java.util.function.Function;
import java.util.function.Supplier;
import net.ethyl.lattice_api.core.content.blocks.BasicStair;
import net.ethyl.lattice_api.core.instances.RegistryId;
import net.ethyl.lattice_api.modules.base.LatticeBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public class LatticeStairBlock
extends LatticeBlock<StairBlock> {
    private final Supplier<Block> defaultBlock;

    private LatticeStairBlock(@NotNull RegistryId registryId, @NotNull DeferredBlock<StairBlock> deferredBlock, @NotNull AppendableBuilder<StairBlock, ? extends LatticeBlock<StairBlock>, ?> builder) {
        super(registryId, deferredBlock, builder);
        this.defaultBlock = builder.defaultBlock;
    }

    public Supplier<Block> getDefaultBlock() {
        return this.defaultBlock;
    }

    public static Builder builder() {
        return new Builder((TriFunction<RegistryId, DeferredBlock<StairBlock>, Builder, LatticeStairBlock>)((TriFunction)LatticeStairBlock::new), BasicStair::new);
    }

    public static class AppendableBuilder<T extends Block, I extends LatticeBlock<T>, B extends AppendableBuilder<T, I, B>>
    extends LatticeBlock.AppendableBuilder<T, I, B> {
        public Supplier<Block> defaultBlock = () -> Blocks.STONE;

        protected AppendableBuilder(@NotNull TriFunction<RegistryId, DeferredBlock<T>, B, I> latticeFactory, @NotNull Function<B, T> blockFactory) {
            super(latticeFactory, blockFactory);
        }

        public B defaultBlock(@NotNull LatticeBlock<?> latticeBlock) {
            this.defaultBlock = latticeBlock::get;
            return (B)((AppendableBuilder)this.self());
        }

        public B defaultBlock(@NotNull Block block) {
            this.defaultBlock = () -> block;
            return (B)((AppendableBuilder)this.self());
        }
    }

    public static class Builder
    extends AppendableBuilder<StairBlock, LatticeStairBlock, Builder> {
        protected Builder(@NotNull TriFunction<RegistryId, DeferredBlock<StairBlock>, Builder, LatticeStairBlock> latticeFactory, @NotNull Function<Builder, StairBlock> blockFactory) {
            super(latticeFactory, blockFactory);
        }
    }
}

