/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.filltweaks.mixin;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.FillCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={FillCommand.class})
public class FillCommandMixin {
    @Unique
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((p_137392_, p_137393_) -> Component.m_237110_((String)"commands.fill.toobig", (Object[])new Object[]{p_137392_, p_137393_}));
    @Unique
    private static final BlockInput HOLLOW_CORE = new BlockInput(Blocks.f_50016_.m_49966_(), Collections.emptySet(), null);
    @Unique
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.fill.failed"));

    @Overwrite
    public static void m_214442_(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fill").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"block", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)context)).executes(cmd -> FillCommandMixin.filltweaks$executeFill((CommandContext<CommandSourceStack>)cmd, context))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"replace").executes(cmd -> FillCommandMixin.filltweaks$executeFill((CommandContext<CommandSourceStack>)cmd, context))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"filter", (ArgumentType)BlockPredicateArgument.m_234627_((CommandBuildContext)context)).executes(cmd -> FillCommandMixin.filltweaks$executeFill((CommandContext<CommandSourceStack>)cmd, context))).then(Commands.m_82129_((String)"modes", (ArgumentType)StringArgumentType.greedyString()).executes(cmd -> FillCommandMixin.filltweaks$executeFill((CommandContext<CommandSourceStack>)cmd, context))))).then(Commands.m_82129_((String)"modes", (ArgumentType)StringArgumentType.greedyString()).executes(cmd -> FillCommandMixin.filltweaks$executeFill((CommandContext<CommandSourceStack>)cmd, context))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"keep").executes(cmd -> FillCommandMixin.filltweaks$executeFill((CommandContext<CommandSourceStack>)cmd, context))).then(Commands.m_82129_((String)"modes", (ArgumentType)StringArgumentType.greedyString()).executes(cmd -> FillCommandMixin.filltweaks$executeFill((CommandContext<CommandSourceStack>)cmd, context))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"outline").executes(cmd -> FillCommandMixin.filltweaks$executeFill((CommandContext<CommandSourceStack>)cmd, context))).then(Commands.m_82129_((String)"modes", (ArgumentType)StringArgumentType.greedyString()).executes(cmd -> FillCommandMixin.filltweaks$executeFill((CommandContext<CommandSourceStack>)cmd, context))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"hollow").executes(cmd -> FillCommandMixin.filltweaks$executeFill((CommandContext<CommandSourceStack>)cmd, context))).then(Commands.m_82129_((String)"modes", (ArgumentType)StringArgumentType.greedyString()).executes(cmd -> FillCommandMixin.filltweaks$executeFill((CommandContext<CommandSourceStack>)cmd, context))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"destroy").executes(cmd -> FillCommandMixin.filltweaks$executeFill((CommandContext<CommandSourceStack>)cmd, context))).then(Commands.m_82129_((String)"modes", (ArgumentType)StringArgumentType.greedyString()).executes(cmd -> FillCommandMixin.filltweaks$executeFill((CommandContext<CommandSourceStack>)cmd, context))))))));
    }

    @Unique
    private static int filltweaks$executeFill(CommandContext<CommandSourceStack> cmd, CommandBuildContext context) throws CommandSyntaxException {
        BoundingBox box = BoundingBox.m_162375_((Vec3i)BlockPosArgument.m_118242_(cmd, (String)"from"), (Vec3i)BlockPosArgument.m_118242_(cmd, (String)"to"));
        BlockInput block = BlockStateArgument.m_116123_(cmd, (String)"block");
        boolean destroy = false;
        boolean outline = false;
        boolean hollow = false;
        boolean keep = false;
        Predicate<BlockInWorld> filter = null;
        try {
            filter = BlockPredicateArgument.m_115573_(cmd, (String)"filter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (ParsedCommandNode node : cmd.getNodes()) {
            String name = node.getNode().getName();
            if (name.equals("destroy")) {
                destroy = true;
                continue;
            }
            if (name.equals("outline")) {
                outline = true;
                continue;
            }
            if (name.equals("hollow")) {
                hollow = true;
                continue;
            }
            if (!name.equals("keep")) continue;
            keep = true;
        }
        try {
            String[] modes;
            String modesArg = StringArgumentType.getString(cmd, (String)"modes");
            for (String mode : modes = modesArg.split("\\s+")) {
                if (mode.equals("destroy")) {
                    destroy = true;
                    continue;
                }
                if (mode.equals("outline")) {
                    outline = true;
                    continue;
                }
                if (mode.equals("hollow")) {
                    hollow = true;
                    continue;
                }
                if (!mode.equals("keep")) continue;
                keep = true;
            }
        }
        catch (IllegalArgumentException modesArg) {
            // empty catch block
        }
        if (keep) {
            Predicate<BlockInWorld> keepFilter = pos -> pos.m_61175_().m_46859_(pos.m_61176_());
            Predicate<BlockInWorld> predicate = filter = filter == null ? keepFilter : filter.and(keepFilter);
        }
        if (outline) {
            Predicate<BlockInWorld> outlineFilter = pos -> {
                BlockPos p = pos.m_61176_();
                return p.m_123341_() == box.m_162395_() || p.m_123341_() == box.m_162399_() || p.m_123342_() == box.m_162396_() || p.m_123342_() == box.m_162400_() || p.m_123343_() == box.m_162398_() || p.m_123343_() == box.m_162401_();
            };
            Predicate<BlockInWorld> predicate = filter = filter == null ? outlineFilter : filter.and(outlineFilter);
        }
        if (hollow) {
            Predicate<BlockInWorld> hollowFilter = pos -> {
                BlockPos p = pos.m_61176_();
                return p.m_123341_() == box.m_162395_() || p.m_123341_() == box.m_162399_() || p.m_123342_() == box.m_162396_() || p.m_123342_() == box.m_162400_() || p.m_123343_() == box.m_162398_() || p.m_123343_() == box.m_162401_();
            };
            filter = filter == null ? hollowFilter : filter.and(hollowFilter);
        }
        return FillCommandMixin.filltweaks$fillBlocksCustom((CommandSourceStack)cmd.getSource(), box, block, destroy, filter, hollow);
    }

    @Unique
    private static int filltweaks$fillBlocksCustom(CommandSourceStack source, BoundingBox box, BlockInput blockInput, boolean destroy, @Nullable Predicate<BlockInWorld> filter, boolean hollow) throws CommandSyntaxException {
        int limit;
        int volume = box.m_71056_() * box.m_71057_() * box.m_71058_();
        if (volume > (limit = source.m_81372_().m_46469_().m_46215_(GameRules.f_263760_))) {
            throw ERROR_AREA_TOO_LARGE.create((Object)limit, (Object)volume);
        }
        ArrayList changedBlocks = Lists.newArrayList();
        ServerLevel level = source.m_81372_();
        int count = 0;
        for (BlockPos pos : BlockPos.m_121976_((int)box.m_162395_(), (int)box.m_162396_(), (int)box.m_162398_(), (int)box.m_162399_(), (int)box.m_162400_(), (int)box.m_162401_())) {
            if (filter != null && !filter.test(new BlockInWorld((LevelReader)level, pos, true))) continue;
            BlockInput toPlace = blockInput;
            if (hollow) {
                boolean isEdge;
                boolean bl = isEdge = pos.m_123341_() == box.m_162395_() || pos.m_123341_() == box.m_162399_() || pos.m_123342_() == box.m_162396_() || pos.m_123342_() == box.m_162400_() || pos.m_123343_() == box.m_162398_() || pos.m_123343_() == box.m_162401_();
                if (!isEdge) {
                    toPlace = HOLLOW_CORE;
                }
            }
            if (destroy) {
                level.m_46961_(pos, true);
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            Clearable.m_18908_((Object)blockEntity);
            if (!toPlace.m_114670_(level, pos, 2)) continue;
            changedBlocks.add(pos.m_7949_());
            ++count;
        }
        for (BlockPos pos : changedBlocks) {
            Block block = level.m_8055_(pos).m_60734_();
            level.m_6289_(pos, block);
        }
        if (count == 0) {
            throw ERROR_FAILED.create();
        }
        int finalCount = count;
        source.m_288197_(() -> Component.m_237110_((String)"commands.fill.success", (Object[])new Object[]{finalCount}), true);
        return count;
    }
}

