/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.client.block_render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix4f;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.common.block.blatgenerator.BlatGeneratorBlockEntity;

public class BlatGeneratorRenderer
implements BlockEntityRenderer<BlatGeneratorBlockEntity> {
    public BlatGeneratorRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(BlatGeneratorBlockEntity entity, float partialTick, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (entity == null || pose == null || buffer == null || !((Boolean)BlatBlock.ConfigClient.GENERATOR_HOLOGRAM.get()).booleanValue()) {
            return;
        }
        List<Component> renderTexts = entity.getRenderText();
        if (renderTexts == null || renderTexts.isEmpty()) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        if (font == null) {
            return;
        }
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        if (entityRenderDispatcher == null) {
            return;
        }
        int size = renderTexts.size();
        int maxLines = Math.min(size, 10);
        for (int i = 0; i < maxLines; ++i) {
            Component text = renderTexts.get(i);
            if (text == null) continue;
            this.renderTextLine(text, i, maxLines, pose, buffer, font, entityRenderDispatcher, packedLight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTextLine(Component text, int lineIndex, int totalLines, PoseStack pose, MultiBufferSource buffer, Font font, EntityRenderDispatcher entityRenderDispatcher, int packedLight) {
        pose.m_85836_();
        try {
            float textWidth = font.m_92852_((FormattedText)text);
            float offsetX = -textWidth / 2.0f;
            float offsetY = 3.0f + (float)(totalLines - lineIndex) * 0.5f;
            pose.m_85837_(0.5, (double)offsetY, 0.5);
            pose.m_252781_(entityRenderDispatcher.m_253208_());
            pose.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = pose.m_85850_().m_252922_();
            font.m_272077_(text, offsetX, 0.0f, this.getTextColor(lineIndex), false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        }
        catch (Exception e) {
            BlatBlock.LOGGER.warn("Failed to render text line {}: {}", (Object)lineIndex, (Object)e.getMessage());
        }
        finally {
            pose.m_85849_();
        }
    }

    private int getTextColor(int lineIndex) {
        return switch (lineIndex) {
            case 0 -> 0xFFFFFF;
            case 1 -> 0x80FF00;
            default -> 0xCCCCCC;
        };
    }
}

