/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Quaternionf;
import ru.blatfan.blatapi.client.guide_book.GuideClient;
import ru.blatfan.blatapi.client.render.FluidRenderMap;
import ru.blatfan.blatapi.utils.ClientTicks;
import ru.blatfan.blatapi.utils.GuiUtil;
import ru.blatfan.blatapi.utils.MathUtils;
import ru.blatfan.blatapi.utils.Text;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.common.block.blatgenerator.BlatGeneratorBlockEntity;
import ru.blatfan.blatblock.common.data.BBLayerManager;
import ru.blatfan.blatblock.common.data.BlatBlockLayer;
import ru.blatfan.blatblock.common.network.BBHandler;
import ru.blatfan.blatblock.common.network.BlatGeneratorPacket;

public class BlatBlockScreen
extends Screen {
    private float page = 0.0f;
    private float tPage = 0.0f;
    private int pageMax;
    protected int leftPos;
    protected int topPos;
    private ResourceLocation current;
    private float entityOffset;
    private float tEntityOffset;
    private float blocksOffset;
    private float tBlocksOffset;
    private final BlatGeneratorBlockEntity entity;
    private final Map<Integer, List<Block>> blockCache = new HashMap<Integer, List<Block>>();
    private final Map<Integer, List<EntityType<?>>> entityCache = new HashMap();
    private final Map<EntityType<?>, Entity> entityPool = new HashMap();
    private int lastCacheUpdate = -1;
    private static final int MAX_VISIBLE_BLOCKS = 49;
    private static final int MAX_VISIBLE_ENTITIES = 16;
    private static final int CACHE_UPDATE_INTERVAL = 30;

    public BlatBlockScreen(BlatGeneratorBlockEntity entity) {
        super((Component)Component.m_237119_());
        this.entity = entity;
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 260) / 2;
        this.topPos = (this.f_96544_ - 134) / 2;
        this.entityOffset = 0.0f;
        this.tEntityOffset = 0.0f;
        this.blocksOffset = 0.0f;
        this.tBlocksOffset = 0.0f;
        super.m_7856_();
    }

    private BlatBlockLayer getBBLevel() {
        return this.getBBLevel(this.current);
    }

    private BlatBlockLayer getBBLevel(ResourceLocation id) {
        BlatBlockLayer level = BBLayerManager.get(id);
        return level != null ? level : BBLayerManager.NULL_BBL;
    }

    public void m_88315_(GuiGraphics gui, int mX, int mY, float partialTick) {
        if (this.current == null) {
            this.current = this.entity.getCurrentLayer();
        }
        this.pageMax = 0;
        for (int i = 0; i < this.entity.getMinedBlocks().size(); ++i) {
            ResourceLocation blockLevel = (ResourceLocation)((Map.Entry)this.entity.getMinedBlocks().entrySet().stream().toList().get(i)).getKey();
            int s = this.f_96547_.m_92852_((FormattedText)this.getBBLevel(blockLevel).getTitle()) + 2;
            this.pageMax += s;
        }
        if (this.pageMax <= 260) {
            this.tPage = 0.0f;
        }
        this.page = MathUtils.lerp((float)this.page, (float)this.tPage, (float)0.1f);
        this.entityOffset = MathUtils.lerp((float)this.entityOffset, (float)this.tEntityOffset, (float)0.1f);
        this.blocksOffset = MathUtils.lerp((float)this.blocksOffset, (float)this.tBlocksOffset, (float)0.1f);
        this.m_280273_(gui);
        this.renderForLevel(gui, this.leftPos, this.topPos, mX, mY, this.entity.getCurrentLevel(this.current));
        if (this.entity.getCurrentLevel(this.current) + 1 < 99) {
            this.renderForLevel(gui, this.leftPos + 130, this.topPos, mX, mY, this.entity.getCurrentLevel(this.current) + 1);
        }
        this.renderButtons(gui, mX, mY, partialTick);
        this.renderSetOrBuy(gui, mX, mY, partialTick);
    }

    private void renderSetOrBuy(GuiGraphics gui, int mX, int mY, float partialTick) {
        ResourceLocation t = BlatBlock.loc("textures/gui/tooltips.png");
        if (this.entity.getCurrentLayer().equals((Object)this.current)) {
            return;
        }
        MutableComponent text = this.entity.getMinedBlock(this.current) > 0 ? Component.m_237115_((String)"tooltip.blatblock.set") : Component.m_237115_((String)"tooltip.blatblock.buy");
        gui.blitNineSlicedSized(t, this.leftPos + 130 - this.f_96547_.m_92852_((FormattedText)text) / 2, this.topPos + 150, this.f_96547_.m_92852_((FormattedText)text) + 4, 16, 11, 33, 33, 0, 0, 33, 33);
        if (!this.canChange(this.current) && BlatBlockScreen.isMouseOver(mX, mY, (float)(this.leftPos + 130) - (float)this.f_96547_.m_92852_((FormattedText)(text = text.m_6881_().m_130940_(ChatFormatting.STRIKETHROUGH))) / 2.0f, this.topPos + 150, this.f_96547_.m_92852_((FormattedText)text) + 4, 16.0)) {
            this.renderTooltip(gui, new ArrayList<Text>(List.of(Text.create((String)"tooltip.blatblock.mined_with_next", (Object[])new Object[]{this.entity.getAllMinedBlock(), this.getBBLevel().getBlockCost()}))), mX, mY);
        }
        gui.m_280430_(this.f_96547_, (Component)text, this.leftPos + 131 - this.f_96547_.m_92852_((FormattedText)text) / 2, this.topPos + 152, Color.WHITE.getRGB());
    }

    private void renderButtons(GuiGraphics gui, int mX, int mY, float partialTick) {
        ResourceLocation b = BlatBlock.loc("textures/gui/buttons.png");
        gui.m_280588_(this.leftPos, this.topPos + 133, this.leftPos + 260, this.topPos + 133 + 16);
        int x = this.leftPos;
        for (int i = 0; i < this.entity.getSorted().size(); ++i) {
            ResourceLocation blockLevel = this.entity.getSorted().get(i);
            int s = this.f_96547_.m_92852_((FormattedText)this.getBBLevel(blockLevel).getTitle()) + 2;
            Color color = this.getBBLevel(blockLevel).getTitleColor();
            gui.m_280246_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
            gui.blitNineSlicedSized(b, (int)((float)x - this.page), this.topPos + 133, s, 16, 6, 32, 16, 0, blockLevel.equals((Object)this.entity.getCurrentLayer()) ? 16 : 0, 32, 32);
            gui.m_280430_(this.f_96547_, this.getBBLevel(blockLevel).getTitle(), (int)((float)(x + 1) - this.page), this.topPos + 133 + 2, (blockLevel.equals((Object)this.entity.getCurrentLayer()) ? Color.WHITE : Color.GRAY).getRGB());
            gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            x += s + 2;
        }
        gui.m_280618_();
    }

    public void m_280273_(GuiGraphics gui) {
        gui.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        ResourceLocation texture = this.getBBLevel().getTexture();
        gui.blitNineSlicedSized(texture, this.leftPos - 1, this.topPos - 1, 260, 134, 10, 30, 30, 0, 0, 64, 64);
        if (this.getBBLevel().getBg() != null) {
            gui.m_280411_(this.getBBLevel().getBg(), this.leftPos, this.topPos, 258, 132, 0.0f, 0.0f, 258, 132, 258, 132);
        }
        GuiUtil.drawScaledCentreString((GuiGraphics)gui, (Component)this.getBBLevel().getTitle(), (int)(this.leftPos + 130), (int)(this.topPos - 18), (Color)this.getBBLevel().getTitleColor(), (float)2.0f);
        if (!this.canChange(this.current)) {
            gui.m_280168_().m_85836_();
            gui.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
            gui.m_280024_(this.leftPos - 1, this.topPos - 1, this.leftPos - 1 + 260, this.topPos - 1 + 134, -1072689136, -804253680);
            gui.m_280168_().m_85849_();
        }
    }

    private void renderForLevel(GuiGraphics gui, int leftPos, int topPos, int mX, int mY, int blockLevel) {
        gui.m_280488_(this.f_96547_, String.valueOf(blockLevel + 1), leftPos, topPos, Color.WHITE.getRGB());
        ResourceLocation texture = this.getBBLevel().getTexture();
        List<Block> levelBlocks = this.getCachedBlocks(blockLevel);
        List<EntityType<?>> levelEntities = this.getCachedEntities(blockLevel);
        ArrayList<Entity> cachedEntities = new ArrayList<Entity>();
        this.renderBlocks(gui, leftPos, topPos, texture, levelBlocks);
        this.renderEntities(gui, leftPos, topPos, texture, levelEntities, cachedEntities);
        this.handleTooltips(gui, leftPos, topPos, mX, mY, blockLevel, levelBlocks, levelEntities, cachedEntities);
    }

    private List<Block> getCachedBlocks(int level) {
        this.updateCacheIfNeeded();
        return this.blockCache.computeIfAbsent(level, l -> {
            List<Block> blocks = this.getBBLevel().getBlocks((int)l);
            return blocks.size() > 49 ? blocks.subList(0, 49) : blocks;
        });
    }

    private List<EntityType<?>> getCachedEntities(int level) {
        this.updateCacheIfNeeded();
        return this.entityCache.computeIfAbsent(level, l -> {
            List<EntityType<?>> entities = this.getBBLevel().getEntities((int)l);
            return entities.size() > 16 ? entities.subList(0, 16) : entities;
        });
    }

    private void updateCacheIfNeeded() {
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        if (currentTime - this.lastCacheUpdate > 30) {
            this.updateCache();
        }
    }

    private void updateCache() {
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        this.blockCache.clear();
        this.entityCache.clear();
        this.lastCacheUpdate = currentTime;
    }

    private Entity getPooledEntity(EntityType<?> type) {
        return this.entityPool.computeIfAbsent(type, t -> {
            try {
                if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
                    return t.m_20615_((Level)this.f_96541_.f_91073_);
                }
                return null;
            }
            catch (Exception e) {
                BlatBlock.LOGGER.warn("Failed to create pooled entity {}: {}", (Object)t.m_20675_(), (Object)e.getMessage());
                return null;
            }
        });
    }

    private void renderBlocks(GuiGraphics gui, int leftPos, int topPos, ResourceLocation texture, List<Block> levelBlocks) {
        int y;
        int x;
        int i;
        if (levelBlocks.isEmpty()) {
            return;
        }
        PoseStack pose = gui.m_280168_();
        gui.m_280588_(leftPos + 1, topPos + 10, leftPos + 129, topPos + 44);
        pose.m_85836_();
        pose.m_252880_(0.0f, -this.blocksOffset, 0.0f);
        for (i = 0; i < levelBlocks.size(); ++i) {
            x = i % 7;
            y = i / 7;
            gui.m_280163_(texture, leftPos + 1 + x * 18, topPos + 10 + y * 18, 0.0f, 30.0f, 18, 18, 64, 64);
        }
        for (i = 0; i < levelBlocks.size(); ++i) {
            x = i % 7;
            y = i / 7;
            ItemStack stack = BlatBlockScreen.getItemStack(levelBlocks.get(i));
            if (stack != null) {
                gui.m_280480_(stack, leftPos + 2 + x * 18, topPos + 11 + y * 18);
                gui.m_280370_(this.f_96547_, stack, leftPos + 2 + x * 18, topPos + 11 + y * 18);
                continue;
            }
            Block block = levelBlocks.get(i);
            if (!(block instanceof LiquidBlock)) continue;
            LiquidBlock l = (LiquidBlock)block;
            TextureAtlasSprite sprite = FluidRenderMap.getCachedFluidTexture((FluidStack)new FluidStack(l.getFluid().m_5613_(), 1000), (FluidRenderMap.FluidFlow)FluidRenderMap.FluidFlow.STILL);
            if (l.getFluid().m_5613_() == Fluids.f_76193_) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            }
            gui.m_280159_(leftPos + 2 + x * 18, topPos + 11 + y * 18, 0, 16, 16, sprite);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        pose.m_85849_();
        gui.m_280618_();
    }

    public static ItemStack getItemStack(Block block) {
        if (block instanceof LiquidBlock) {
            return null;
        }
        Item blockItem = (Item)BlockItem.f_41373_.get(block);
        if (blockItem != null && blockItem != Items.f_41852_) {
            return new ItemStack((ItemLike)blockItem);
        }
        Item asItem = block.m_5456_();
        if (asItem != Items.f_41852_) {
            return new ItemStack((ItemLike)asItem);
        }
        return ItemStack.f_41583_;
    }

    private void renderEntities(GuiGraphics gui, int leftPos, int topPos, ResourceLocation texture, List<EntityType<?>> levelEntities, List<Entity> cachedEntities) {
        int i;
        if (levelEntities.isEmpty() || this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        PoseStack pose = gui.m_280168_();
        gui.m_280588_(leftPos + 1, topPos + 45, leftPos + 129, topPos + 132);
        pose.m_85836_();
        pose.m_252880_(0.0f, -this.entityOffset, 0.0f);
        for (i = 0; i < levelEntities.size(); ++i) {
            int x = i % 4;
            int y = i / 4;
            gui.m_280163_(texture, leftPos + 1 + x * 32, topPos + 45 + y * 48, 32.0f, 0.0f, 32, 48, 64, 64);
        }
        for (i = 0; i < levelEntities.size(); ++i) {
            EntityType<?> entityType = levelEntities.get(i);
            Entity entity = this.getPooledEntity(entityType);
            cachedEntities.add(entity);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            int x = i % 4;
            int y = i / 4;
            living.f_20885_ = 0.0f;
            living.f_20886_ = 0.0f;
            float rotation = (float)ClientTicks.ticks + (float)(i * 10);
            try {
                GuiUtil.renderEntityQuaternionf((GuiGraphics)gui, (int)(leftPos + 16 + x * 32), (int)(topPos + 83 + (living.m_20192_() > 2.0f ? 7 : 0) - (living.m_20192_() < 1.0f ? 7 : 0) + y * 48), (int)16, (Quaternionf)Axis.f_252436_.m_252977_(rotation), (Quaternionf)Axis.f_252529_.m_252977_(180.0f), (LivingEntity)living);
                continue;
            }
            catch (Exception e) {
                BlatBlock.LOGGER.warn("Failed to render entity {}: {}", (Object)entityType.m_20675_(), (Object)e.getMessage());
            }
        }
        pose.m_85849_();
        gui.m_280618_();
    }

    private void handleTooltips(GuiGraphics gui, int leftPos, int topPos, int mX, int mY, int blockLevel, List<Block> levelBlocks, List<EntityType<?>> levelEntities, List<Entity> cachedEntities) {
        int i;
        for (i = 0; i < levelBlocks.size(); ++i) {
            int x = i % 7;
            int blockX = leftPos + 2 + x * 18;
            int y = i / 7;
            int blockY = topPos + 11 + y * 18 - (int)this.blocksOffset;
            if (!BlatBlockScreen.isMouseOver(mX, mY, blockX, blockY, 16.0, 16.0) || !BlatBlockScreen.isMouseOver(mX, mY, leftPos + 1, topPos + 10, 128.0, 34.0)) continue;
            ItemStack item = BlatBlockScreen.getItemStack(levelBlocks.get(i));
            float chance = this.getBBLevel().get(levelBlocks.get(i)).chance(blockLevel);
            if (item != null) {
                this.renderTooltip(gui, item, chance, mX, mY);
            } else {
                Block block = levelBlocks.get(i);
                if (block instanceof LiquidBlock) {
                    LiquidBlock l = (LiquidBlock)block;
                    this.renderTooltip(gui, (Fluid)l.getFluid(), chance, mX, mY);
                }
            }
            return;
        }
        for (i = 0; i < Math.min(levelEntities.size(), cachedEntities.size()); ++i) {
            int y;
            int entityY;
            int x;
            int entityX;
            Entity entity = cachedEntities.get(i);
            if (entity == null || !BlatBlockScreen.isMouseOver(mX, mY, entityX = leftPos + 1 + (x = i % 4) * 32, entityY = topPos + 45 + (y = i / 4) * 48 - (int)this.entityOffset, 32.0, 48.0) || !BlatBlockScreen.isMouseOver(mX, mY, leftPos + 1, topPos + 45, 128.0, 87.0)) continue;
            float chance = this.getBBLevel().get(levelEntities.get(i)).chance(blockLevel);
            this.renderTooltip(gui, entity, chance, mX, mY);
            return;
        }
    }

    public static boolean isMouseOver(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private void renderTooltip(GuiGraphics gui, List<Component> tooltips, int rawMX, int rawMY) {
        ResourceLocation t = BlatBlock.loc("textures/gui/tooltips.png");
        int mX = rawMX + 8;
        int mY = rawMY - 8;
        Color color = this.getBBLevel().getTitleColor();
        AtomicInteger maxWidth = new AtomicInteger();
        tooltips.set(0, (Component)Text.create((String)"  ").add(tooltips.get(0)));
        tooltips.forEach(tooltip -> {
            if (maxWidth.get() < this.f_96547_.m_92852_((FormattedText)tooltip) + 2) {
                maxWidth.set(this.f_96547_.m_92852_((FormattedText)tooltip) + 2);
                if (tooltips.indexOf(tooltip) == tooltips.size() - 1) {
                    maxWidth.set(maxWidth.get() + 2);
                }
            }
        });
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.7f);
        int n = maxWidth.get();
        int n2 = tooltips.size();
        Objects.requireNonNull(this.f_96547_);
        gui.blitNineSlicedSized(t, mX, mY - 1, n, n2 * 9 + 2, 11, 33, 33, 0, 0, 33, 33);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        for (int i = 0; i < tooltips.size(); ++i) {
            Objects.requireNonNull(this.f_96547_);
            gui.m_280430_(this.f_96547_, tooltips.get(i), mX + 1, mY + 1 + i * 9, Color.WHITE.getRGB());
        }
        gui.m_280168_().m_85849_();
    }

    private void renderTooltip(GuiGraphics gui, ItemStack item, float chance, int mX, int mY) {
        List tooltips = item.m_41651_(GuideClient.player, GuideClient.tooltipFlag);
        Item item2 = item.m_41720_();
        if (item2 instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item2;
            tooltips.set(0, bucketItem.getFluid().getFluidType().getDescription());
        }
        tooltips.add(Text.create((String)"tooltip.blatblock.chance").add(String.format("%.1f%%", Float.valueOf(chance * 100.0f))));
        this.renderTooltip(gui, tooltips, mX, mY);
    }

    private void renderTooltip(GuiGraphics gui, Fluid fluid, float chance, int mX, int mY) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add(fluid.getFluidType().getDescription());
        tooltips.add((Component)Text.create((String)BuiltInRegistries.f_257020_.m_7981_((Object)fluid).toString()).withColor(Color.DARK_GRAY));
        tooltips.add((Component)Text.create((String)"tooltip.blatblock.chance").add(String.format("%.1f%%", Float.valueOf(chance * 100.0f))));
        this.renderTooltip(gui, tooltips, mX, mY);
    }

    private void renderTooltip(GuiGraphics gui, Entity entity, float chance, int mX, int mY) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add(entity.m_5446_());
        tooltips.add((Component)Text.create((String)BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()).toString()).withColor(Color.DARK_GRAY));
        tooltips.add((Component)Text.create((String)"tooltip.blatblock.chance").add(String.format("%.1f%%", Float.valueOf(chance * 100.0f))));
        this.renderTooltip(gui, tooltips, mX, mY);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        int x = this.leftPos;
        for (int i = 0; i < this.entity.getSorted().size(); ++i) {
            ResourceLocation blockLevel = this.entity.getSorted().get(i);
            int s = this.f_96547_.m_92852_((FormattedText)this.getBBLevel(blockLevel).getTitle()) + 2;
            if (pButton == 0 && BlatBlockScreen.isMouseOver(pMouseX, pMouseY, (float)x - this.page, this.topPos + 133, s, 16.0)) {
                this.current = blockLevel;
                this.updateCache();
                this.tBlocksOffset = 0.0f;
                this.tEntityOffset = 0.0f;
                return true;
            }
            x += s + 2;
        }
        if (!this.entity.getCurrentLayer().equals((Object)this.current) && pButton == 0 && this.canChange(this.current)) {
            MutableComponent text;
            boolean isSet = this.entity.getMinedBlock(this.current) > 0;
            MutableComponent mutableComponent = text = isSet ? Component.m_237115_((String)"tooltip.blatblock.set") : Component.m_237115_((String)"tooltip.blatblock.buy");
            if (BlatBlockScreen.isMouseOver(pMouseX, pMouseY, (double)(this.leftPos + 130) - (double)this.f_96547_.m_92852_((FormattedText)text) / 2.0, this.topPos + 150, (double)this.f_96547_.m_92852_((FormattedText)text) / 2.0 + 4.0, 16.0)) {
                BBHandler.sendToServer(new BlatGeneratorPacket(this.entity.m_58899_(), this.current, isSet ? BlatGeneratorPacket.Type.SET : BlatGeneratorPacket.Type.BUY));
                this.m_7379_();
                return true;
            }
        }
        return false;
    }

    private boolean canChange(ResourceLocation bbl) {
        return this.entity.getAllMinedBlock() >= BBLayerManager.get(bbl).getBlockCost();
    }

    public boolean m_6050_(double mX, double mY, double delta) {
        if (BlatBlockScreen.isMouseOver(mX, mY, this.leftPos + 1, this.topPos + 10, 258.0, 34.0)) {
            List<Block> allBlocks = this.getCachedBlocks(this.entity.getCurrentLevel());
            int maxRows = (allBlocks.size() + 6) / 7;
            float visibleRows = 1.8f;
            float maxOffset = Math.max(0.0f, ((float)maxRows - visibleRows) * 18.0f);
            this.tBlocksOffset = Math.max(0.0f, Math.min(maxOffset, this.tBlocksOffset - (float)delta * 18.0f));
            return true;
        }
        if (BlatBlockScreen.isMouseOver(mX, mY, this.leftPos + 1, this.topPos + 45, 258.0, 87.0)) {
            List<EntityType<?>> allEntities = this.getCachedEntities(this.entity.getCurrentLevel());
            int maxRows = (allEntities.size() + 3) / 4;
            float visibleRows = 1.8f;
            float maxOffset = Math.max(0.0f, ((float)maxRows - visibleRows) * 48.0f);
            this.tEntityOffset = Math.max(0.0f, Math.min(maxOffset, this.tEntityOffset - (float)delta * 48.0f));
            return true;
        }
        if (BlatBlockScreen.isMouseOver(mX, mY, this.leftPos, this.topPos + 133, 260.0, 16.0)) {
            this.tPage = Math.max(0.0f, Math.min((float)this.pageMax, this.tPage - (float)delta * 16.0f));
            return true;
        }
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256 || pKeyCode == 69) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_7379_() {
        this.blockCache.clear();
        this.entityCache.clear();
        this.entityPool.values().forEach(entity -> {
            if (entity != null) {
                entity.m_146870_();
            }
        });
        this.entityPool.clear();
        super.m_7379_();
    }
}

