/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.common.block.autogenerator;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import ru.blatfan.blatapi.fluffy_fur.common.block.BlatEntityBlock;
import ru.blatfan.blatblock.common.block.autogenerator.AutoGeneratorBlockEntity;
import ru.blatfan.blatblock.common.block.autogenerator.AutoGeneratorMenu;

public class AutoGeneratorBlock
extends BlatEntityBlock {
    private final Type type;

    protected AutoGeneratorBlock(Type type) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60955_(), AutoGeneratorBlockEntity::new);
        this.type = type;
    }

    public static AutoGeneratorBlock basic() {
        return new AutoGeneratorBlock(Type.BASIC);
    }

    public static AutoGeneratorBlock improved() {
        return new AutoGeneratorBlock(Type.IMPROVED);
    }

    public static AutoGeneratorBlock perfect() {
        return new AutoGeneratorBlock(Type.PERFECT);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.f_46443_ && !pPlayer.m_6144_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)this.menuProvider(pPos), data -> {
                data.m_130064_(pPos);
                data.m_130068_((Enum)this.type);
            });
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return (level, pos, state, be) -> ((AutoGeneratorBlockEntity)be).tick(level, pos, this.type);
    }

    public MenuProvider menuProvider(final BlockPos pos) {
        return new MenuProvider(){

            public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
                return new AutoGeneratorMenu(pContainerId, pos, pPlayerInventory, AutoGeneratorBlock.this.type);
            }

            public Component m_5446_() {
                return AutoGeneratorBlock.this.m_49954_();
            }
        };
    }

    public static enum Type {
        BASIC,
        IMPROVED,
        PERFECT;

    }
}

