/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.common.block.autogenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import ru.blatfan.blatapi.common.block.BlockISSimpleInventory;
import ru.blatfan.blatapi.utils.BaseItemStackHandler;
import ru.blatfan.blatapi.utils.ItemHelper;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.common.BBRegistry;
import ru.blatfan.blatblock.common.block.autogenerator.AutoGeneratorBlock;
import ru.blatfan.blatblock.common.block.blatgenerator.BlatGeneratorBlockEntity;
import ru.blatfan.blatblock.common.data.BBLayerManager;
import ru.blatfan.blatblock.common.data.BlatBlockLayer;
import ru.blatfan.blatblock.common.events.GeneratorEvents;
import ru.blatfan.blatblock.common.item.GeneratorUpgradeItem;
import ru.blatfan.blatblock.common.network.BBHandler;
import ru.blatfan.blatblock.common.network.BBParticlePacket;

public class AutoGeneratorBlockEntity
extends BlockISSimpleInventory {
    private int progress = 0;
    private int progressMax = 1;
    private ResourceLocation cachedBBL = null;
    private int cachedBBLLevel = 0;
    private final float[] cachedModifiers = new float[GeneratorUpgradeItem.Type.values().length];
    private boolean modifiersCached = false;
    private static final int STORAGE_SLOTS = 27;
    private static final int UPGRADE_SLOTS_START = 27;
    private static final int UPGRADE_SLOTS_END = 31;
    private static final int TOTAL_SLOTS = 31;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> AutoGeneratorBlockEntity.this.progress;
                case 1 -> AutoGeneratorBlockEntity.this.progressMax;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AutoGeneratorBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    AutoGeneratorBlockEntity.this.progressMax = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public AutoGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BBRegistry.BLOCK_ENTITIES.AUTO_GENERATOR.get(), pos, state);
    }

    protected BaseItemStackHandler createItemHandler() {
        return BaseItemStackHandler.create((int)31, this::m_6596_);
    }

    public int tickInterval(AutoGeneratorBlock.Type type) {
        float speedMod = this.getCachedModifier(GeneratorUpgradeItem.Type.SPEED);
        int baseRate = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case AutoGeneratorBlock.Type.BASIC -> (Integer)BlatBlock.ConfigCommon.BASIC_TICK_RATE.get();
            case AutoGeneratorBlock.Type.IMPROVED -> (Integer)BlatBlock.ConfigCommon.IMPROVED_TICK_RATE.get();
            case AutoGeneratorBlock.Type.PERFECT -> (Integer)BlatBlock.ConfigCommon.PERFECT_TICK_RATE.get();
        };
        return Math.max(1, Math.round((float)(baseRate * 20) / speedMod));
    }

    public void tick(Level level, BlockPos pos, AutoGeneratorBlock.Type type) {
        if (level.f_46443_) {
            return;
        }
        if (this.cachedBBLLevel == -1) {
            this.cachedBBL = null;
        }
        if (this.cachedBBL == null) {
            this.updateBBLData();
        }
        if (this.cachedBBL != null && this.hasFreeSlots() > -1) {
            this.progressMax = this.tickInterval(type);
            ++this.progress;
        } else {
            this.resetProgress();
        }
        if (this.progress >= this.progressMax && this.cachedBBL != null) {
            this.progress = 0;
            this.generateItems(level, pos);
        }
    }

    private void generateItems(Level level, BlockPos pos) {
        BlatBlockLayer layer = BBLayerManager.get(this.cachedBBL);
        if (layer == BBLayerManager.NULL_BBL) {
            return;
        }
        Random random = new Random();
        this.generateBlocks(level, pos, layer, random);
        this.generateEntityDrops(level, pos, layer, random);
    }

    private void generateBlocks(Level level, BlockPos pos, BlatBlockLayer layer, Random random) {
        BlockState dropState = layer.getRandBlock(random, this.cachedBBLLevel);
        if (dropState.m_60734_() instanceof LiquidBlock) {
            return;
        }
        ItemStack drop = GeneratorEvents.dropStack(dropState.m_60734_(), this.getCachedModifier(GeneratorUpgradeItem.Type.TAG) >= 1.0f);
        if (drop.m_41619_()) {
            return;
        }
        int fortuneAmount = random.nextInt(Math.max(1, (int)this.getCachedModifier(GeneratorUpgradeItem.Type.FORTUNE)));
        drop.m_41764_(Math.max(1, fortuneAmount));
        this.addItemToStorage(drop);
        this.sendParticlePacket(level, pos, drop);
    }

    private void generateEntityDrops(Level level, BlockPos pos, BlatBlockLayer layer, Random random) {
        float entityMod = this.getCachedModifier(GeneratorUpgradeItem.Type.ENTITY);
        if (entityMod <= 1.0f) {
            return;
        }
        EntityType<?> entityType = layer.getRandEntity(random, this.cachedBBLLevel);
        if (entityType == null) {
            return;
        }
        LivingEntity entity = (LivingEntity)entityType.m_20615_(level);
        if (entity == null) {
            return;
        }
        DamageSource damageSource = level.m_269111_().m_269264_();
        ArrayList drops = new ArrayList();
        entity.captureDrops(drops);
        entity.m_7625_(damageSource, true);
        entity.m_7472_(damageSource, random.nextInt((int)entityMod), true);
        for (ItemEntity itemEntity : entity.captureDrops(null)) {
            ItemStack drop = itemEntity.m_32055_();
            if (!this.addItemToStorage(drop)) continue;
            this.sendParticlePacket(level, pos, drop);
        }
    }

    private boolean addItemToStorage(ItemStack stack) {
        int slot = this.hasFreeSlots(stack);
        if (slot == -1) {
            return false;
        }
        ItemStack existing = this.getItemHandler().getStackInSlot(slot);
        ItemStack combined = ItemHelper.withSize((ItemStack)stack, (int)(stack.m_41613_() + existing.m_41613_()), (boolean)false);
        this.getItemHandler().setStackInSlot(slot, combined);
        return true;
    }

    private void sendParticlePacket(Level level, BlockPos pos, ItemStack stack) {
        BBHandler.sendToTracking(level, pos.m_7494_(), (Object)new BBParticlePacket(pos.m_7494_().m_252807_().m_82520_(0.0, -0.45, 0.0), stack));
    }

    public void updateBBLData() {
        BlockPos[] checkPositions;
        if (this.f_58857_ == null) {
            return;
        }
        for (BlockPos checkPos : checkPositions = new BlockPos[]{this.m_58899_().m_7918_(1, -1, 0), this.m_58899_().m_7918_(-1, -1, 0), this.m_58899_().m_7918_(0, -1, 1), this.m_58899_().m_7918_(0, -1, -1)}) {
            BlockEntity entity = this.f_58857_.m_7702_(checkPos);
            if (!(entity instanceof BlatGeneratorBlockEntity)) continue;
            BlatGeneratorBlockEntity generator = (BlatGeneratorBlockEntity)entity;
            this.cachedBBL = generator.getCurrentLayer();
            this.cachedBBLLevel = generator.getCurrentLevel();
            BlatBlock.LOGGER.debug("Updated BBL data: {} level {}", (Object)(this.cachedBBL != null ? this.cachedBBL.toString() : "null"), (Object)this.cachedBBLLevel);
            return;
        }
    }

    public float getCachedModifier(GeneratorUpgradeItem.Type type) {
        if (!this.modifiersCached) {
            this.updateModifierCache();
        }
        return this.cachedModifiers[type.ordinal()];
    }

    private void updateModifierCache() {
        Arrays.fill(this.cachedModifiers, 1.0f);
        for (ItemStack stack : this.getUpgrades()) {
            int index;
            Item item = stack.m_41720_();
            if (!(item instanceof GeneratorUpgradeItem)) continue;
            GeneratorUpgradeItem upgrade = (GeneratorUpgradeItem)item;
            int n = index = upgrade.getType().ordinal();
            this.cachedModifiers[n] = this.cachedModifiers[n] + upgrade.getQuality();
        }
        this.modifiersCached = true;
    }

    public List<ItemStack> getUpgrades() {
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        for (int i = 27; i < 31; ++i) {
            ItemStack stack = this.getItemHandler().getStackInSlot(i);
            if (!(stack.m_41720_() instanceof GeneratorUpgradeItem)) continue;
            upgrades.add(stack);
        }
        return upgrades;
    }

    public void m_6596_() {
        super.m_6596_();
        this.updateBBLData();
        this.invalidateModifierCache();
    }

    private void invalidateModifierCache() {
        this.modifiersCached = false;
    }

    private void resetProgress() {
        this.progress = 0;
        this.progressMax = 0;
    }

    public int hasFreeSlots(ItemStack stack) {
        for (int i = 0; i < 27; ++i) {
            ItemStack slot = this.getItemHandler().getStackInSlot(i);
            if (!slot.m_41619_() && (!ItemHelper.areStacksEqual((ItemStack)slot, (ItemStack)stack) || slot.m_41613_() + stack.m_41613_() > slot.m_41741_())) continue;
            return i;
        }
        return -1;
    }

    public int hasFreeSlots() {
        for (int i = 0; i < 27; ++i) {
            if (!this.getItemHandler().getStackInSlot(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.progress);
        if (this.cachedBBL != null) {
            tag.m_128359_("cachedBBL", this.cachedBBL.toString());
            tag.m_128405_("cachedBBLLevel", this.cachedBBLLevel);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("progress");
        if (tag.m_128441_("cachedBBL")) {
            this.cachedBBL = ResourceLocation.m_135820_((String)tag.m_128461_("cachedBBL"));
            this.cachedBBLLevel = tag.m_128451_("cachedBBLLevel");
        }
        this.invalidateModifierCache();
    }

    public ContainerData getData() {
        return this.dataAccess;
    }
}

