/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.common.block.blatgenerator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import ru.blatfan.blatapi.fluffy_fur.common.block.entity.BlockEntityBase;
import ru.blatfan.blatapi.utils.Text;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.common.BBRegistry;
import ru.blatfan.blatblock.common.block.autogenerator.AutoGeneratorBlockEntity;
import ru.blatfan.blatblock.common.data.BBLayerManager;
import ru.blatfan.blatblock.common.data.BlatBlockLayer;

public class BlatGeneratorBlockEntity
extends BlockEntityBase {
    private ResourceLocation currentLayer = BlatBlock.loc("null");
    private final Map<ResourceLocation, Integer> minedBlocks = new HashMap<ResourceLocation, Integer>();
    private int tickCounter = 0;

    public BlatGeneratorBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BBRegistry.BLOCK_ENTITIES.BLAT_GENERATOR.get(), pos, blockState);
        this.random = new Random();
    }

    public void tick(Level level, BlockPos pos) {
        ++this.tickCounter;
        if (this.currentLayer.m_135815_().equals("null")) {
            this.currentLayer = BBLayerManager.getBaseId();
            this.setMinedBlock(this.currentLayer, 1);
        }
        if (level.f_46443_) {
            if (this.tickCounter % 40 == 0 && this.random.nextInt(5) == 0) {
                level.m_245747_(pos, SoundEvents.f_144245_, SoundSource.BLOCKS, 1.0f, 1.0f, true);
            }
        } else if (level.m_8055_(pos.m_7494_()).m_60795_() && this.getMinedBlock() > 0) {
            Player player = level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 5.0, false);
            this.addMinedBlock(1);
            BlatBlockLayer lvlData = BBLayerManager.get(this.currentLayer);
            if (player != null && player.m_20183_().m_123331_(Vec3i.f_123288_) <= 2.0) {
                player.m_20256_(new Vec3(0.0, 1.0, 0.0));
            }
            if (lvlData != null) {
                lvlData.rand(player, level, pos.m_7494_(), this.random, this.getCurrentLevel());
            } else {
                BlatBlock.LOGGER.warn("No BlatBlockLayer data for {}", (Object)this.currentLayer);
                this.currentLayer = BBLayerManager.getBaseId();
            }
            this.m_6596_();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("block_level", this.currentLayer.toString());
        CompoundTag minedTag = new CompoundTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.minedBlocks.entrySet()) {
            minedTag.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
        }
        tag.m_128365_("mined_block", (Tag)minedTag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        try {
            String lvlStr = tag.m_128461_("block_level");
            if (lvlStr.isEmpty()) {
                BlatBlock.LOGGER.warn("Empty block_level in NBT at {}", (Object)this.m_58899_());
                this.currentLayer = BlatBlock.loc("null");
            } else {
                ResourceLocation parsed = ResourceLocation.m_135820_((String)lvlStr);
                this.currentLayer = parsed != null ? parsed : BlatBlock.loc("null");
            }
            this.minedBlocks.clear();
            if (tag.m_128425_("mined_block", 10)) {
                CompoundTag minedTag = tag.m_128469_("mined_block");
                for (ResourceLocation id : BBLayerManager.getAvailableIds()) {
                    int count = minedTag.m_128451_(id.toString());
                    this.minedBlocks.put(id, Math.max(0, count));
                }
            }
        }
        catch (Exception e) {
            BlatBlock.LOGGER.error("Error loading BlatGeneratorBlockEntity NBT at {}: {}", (Object)this.m_58899_(), (Object)e.getMessage());
            this.resetToDefaults();
        }
    }

    private void resetToDefaults() {
        this.minedBlocks.clear();
        this.currentLayer = BBLayerManager.getBaseId();
    }

    public List<Component> getRenderText() {
        ArrayList<Component> list = new ArrayList<Component>();
        BlatBlockLayer bbl = BBLayerManager.NULL_BBL;
        try {
            bbl = BBLayerManager.get(this.currentLayer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int currentLevel = this.getCurrentLevel();
        int minedBlocks = this.getMinedBlock();
        boolean isMaxLevel = currentLevel >= 99;
        String levelText = isMaxLevel ? Component.m_237115_((String)"tooltip.blatblock.max").getString() : String.valueOf(currentLevel + 1);
        list.add((Component)Text.create((String)"tooltip.blatblock.level", (Object[])new Object[]{bbl.getTitle().getString(), levelText}).withColor(bbl.getTitleColor()).asComponent());
        if (!isMaxLevel) {
            list.add((Component)Text.create((String)"tooltip.blatblock.mined_with_next", (Object[])new Object[]{minedBlocks, (int)bbl.calcBlocks(currentLevel + 1)}).withColor(bbl.getTitleColor()).asComponent());
        } else {
            list.add((Component)Text.create((String)"tooltip.blatblock.mined", (Object[])new Object[]{minedBlocks}).withColor(bbl.getTitleColor()).asComponent());
        }
        if (!isMaxLevel) {
            int levelBlocks = currentLevel > 0 ? (int)bbl.calcBlocks(currentLevel) : 0;
            int nextLevelBlocks = (int)(bbl.calcBlocks(currentLevel + 1) - (float)levelBlocks);
            if (nextLevelBlocks > 0) {
                int progress = Math.round((float)(minedBlocks - levelBlocks) / (float)nextLevelBlocks * 100.0f);
                list.add((Component)Text.create((String)"tooltip.blatblock.progress", (Object[])new Object[]{String.valueOf(Math.min(progress, 100))}).add("%").withColor(bbl.getTitleColor()).asComponent());
            }
        } else {
            list.add((Component)Text.create((String)"tooltip.blatblock.max_level").withColor(bbl.getTitleColor()).asComponent());
        }
        return list;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-2, 0, -2), this.f_58858_.m_7918_(2, 5, 2));
    }

    public List<ResourceLocation> getSorted() {
        return this.minedBlocks.keySet().stream().sorted(Comparator.comparingInt(id -> {
            BlatBlockLayer level = BBLayerManager.get(id);
            return level != null ? level.getSort() : Integer.MAX_VALUE;
        })).collect(Collectors.toList());
    }

    public int getLevelBlocks() {
        return this.getLevelBlocks(this.currentLayer);
    }

    public int getLevelBlocks(ResourceLocation id) {
        BlatBlockLayer lvlData = BBLayerManager.get(id);
        if (lvlData == null) {
            BlatBlock.LOGGER.warn("No BlatBlockLayer for {} in getBlockLevel()", (Object)id);
            return 0;
        }
        return (int)lvlData.calcBlocks(this.getCurrentLevel());
    }

    public int getCurrentLevel() {
        return this.getCurrentLevel(this.currentLayer);
    }

    public int getCurrentLevel(ResourceLocation id) {
        int requiredBlocks;
        int level;
        BlatBlockLayer lvlData = BBLayerManager.get(id);
        if (lvlData == null) {
            BlatBlock.LOGGER.warn("No BlatBlockLayer for {} in getCurrentLevel()", (Object)id);
            return 0;
        }
        int minedCount = this.getMinedBlock(id);
        int maxLevel = 99;
        for (level = 0; level < maxLevel && minedCount >= (requiredBlocks = (int)lvlData.calcBlocks(level + 1)); ++level) {
        }
        return level;
    }

    public void m_6596_() {
        super.m_6596_();
        ArrayList<BlockEntity> entities = new ArrayList<BlockEntity>();
        if (this.f_58857_ == null) {
            return;
        }
        entities.add(this.f_58857_.m_7702_(this.m_58899_().m_7918_(1, 0, 0)));
        entities.add(this.f_58857_.m_7702_(this.m_58899_().m_7918_(-1, 0, 0)));
        entities.add(this.f_58857_.m_7702_(this.m_58899_().m_7918_(0, 0, 1)));
        entities.add(this.f_58857_.m_7702_(this.m_58899_().m_7918_(0, 0, -1)));
        for (BlockEntity entity : entities) {
            if (!(entity instanceof AutoGeneratorBlockEntity)) continue;
            entity.m_6596_();
        }
    }

    public int getMinedBlock() {
        return this.getMinedBlock(this.currentLayer);
    }

    public int getAllMinedBlock() {
        AtomicInteger m = new AtomicInteger();
        this.minedBlocks.forEach((r, i) -> m.addAndGet((int)i));
        return m.get();
    }

    public void setMinedBlock(int count) {
        this.setMinedBlock(this.currentLayer, count);
    }

    public void addMinedBlock(int delta) {
        this.addMinedBlock(this.currentLayer, delta);
    }

    public int getMinedBlock(ResourceLocation id) {
        return this.minedBlocks.getOrDefault(id, 0);
    }

    public void setMinedBlock(ResourceLocation id, int count) {
        this.minedBlocks.put(id, Math.max(0, count));
        this.m_6596_();
    }

    public void addMinedBlock(ResourceLocation id, int delta) {
        this.setMinedBlock(this.getMinedBlock(id) + delta);
    }

    public ResourceLocation getCurrentLayer() {
        return this.currentLayer;
    }

    public void setCurrentLayer(ResourceLocation currentLayer) {
        this.currentLayer = currentLayer;
    }

    public Map<ResourceLocation, Integer> getMinedBlocks() {
        return this.minedBlocks;
    }
}

