/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.common.item;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class MultitoolItem
extends DiggerItem {
    public static final TagKey<Block> MINEABLE_WITH_MULTITOOL = BlockTags.create((ResourceLocation)new ResourceLocation("mineable/multitool"));
    private float attackDamage;
    private float attackSpeed;

    public MultitoolItem(float attackDamage, float attackSpeed, Tier pTier, Item.Properties pProperties) {
        super(0.0f, 0.0f, pTier, MINEABLE_WITH_MULTITOOL, pProperties);
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)(this.attackDamage - 1.0f), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)(this.attackSpeed - 4.0f), AttributeModifier.Operation.ADDITION));
        ImmutableMultimap defaultModifiers = builder.build();
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState tilledState;
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Optional<BlockState> strippedState = MultitoolItem.getStripped(blockstate);
        if (strippedState.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                level.m_7731_(blockpos, strippedState.get(), 11);
                context.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        Optional<BlockState> scrapedState = MultitoolItem.getScraped(blockstate);
        if (scrapedState.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, blockpos, 0);
            if (!level.f_46443_) {
                level.m_7731_(blockpos, scrapedState.get(), 11);
                context.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        Optional<BlockState> waxOffState = MultitoolItem.getWaxOff(blockstate);
        if (waxOffState.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, blockpos, 0);
            if (!level.f_46443_) {
                level.m_7731_(blockpos, waxOffState.get(), 11);
                context.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (blockstate.m_61138_((Property)BlockStateProperties.f_61443_) && ((Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue() && (blockstate.m_60713_(Blocks.f_50683_) || blockstate.m_60713_(Blocks.f_50684_))) {
            if (!level.f_46443_) {
                level.m_5898_(player, 1009, blockpos, 0);
                CampfireBlock.m_152749_((Entity)player, (LevelAccessor)level, (BlockPos)blockpos, (BlockState)blockstate);
                level.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 11);
                context.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (context.m_43719_() != Direction.DOWN && level.m_46859_(blockpos.m_7494_()) && (tilledState = level.m_8055_(blockpos).getToolModifiedState(context, ToolActions.HOE_TILL, false)) != null) {
            level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                level.m_7731_(blockpos, tilledState, 11);
                context.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static Optional<BlockState> getStripped(BlockState state) {
        return Optional.ofNullable((Block)AxeItem.f_150683_.get(state.m_60734_())).map(block -> (BlockState)block.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))));
    }

    private static Optional<BlockState> getScraped(BlockState state) {
        return Optional.ofNullable((Block)((BiMap)HoneycombItem.f_150864_.get()).get((Object)state.m_60734_())).map(Block::m_49966_);
    }

    private static Optional<BlockState> getWaxOff(BlockState state) {
        return Optional.ofNullable((Block)((BiMap)HoneycombItem.f_150863_.get()).get((Object)state.m_60734_())).map(Block::m_49966_);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.DIGGER || enchantment.f_44672_ == EnchantmentCategory.BREAKABLE || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int m_6473_() {
        return Math.max(this.m_43314_().m_6601_(), 10);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_HOE_ACTIONS.contains(toolAction) || ToolActions.SHOVEL_DIG == toolAction || ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    public static MultitoolItem wooden() {
        return new MultitoolItem(5.0f, 1.2f, (Tier)Tiers.WOOD, new Item.Properties().m_41487_(1).m_41499_(120));
    }

    public static MultitoolItem stone() {
        return new MultitoolItem(6.0f, 1.2f, (Tier)Tiers.STONE, new Item.Properties().m_41487_(1).m_41499_(260));
    }

    public static MultitoolItem iron() {
        return new MultitoolItem(7.0f, 1.2f, (Tier)Tiers.IRON, new Item.Properties().m_41487_(1).m_41499_(500));
    }

    public static MultitoolItem gold() {
        return new MultitoolItem(5.0f, 1.6f, (Tier)Tiers.GOLD, new Item.Properties().m_41487_(1).m_41499_(64));
    }

    public static MultitoolItem diamond() {
        return new MultitoolItem(8.0f, 1.2f, (Tier)Tiers.DIAMOND, new Item.Properties().m_41487_(1).m_41499_(3120));
    }

    public static MultitoolItem netherite() {
        return new MultitoolItem(9.0f, 1.2f, (Tier)Tiers.NETHERITE, new Item.Properties().m_41487_(1).m_41499_(4060).m_41486_());
    }

    public float m_41008_() {
        return this.attackDamage;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public void setAttackDamage(float attackDamage) {
        this.attackDamage = attackDamage;
    }

    public void setAttackSpeed(float attackSpeed) {
        this.attackSpeed = attackSpeed;
    }
}

