/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.compat.jei;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.common.data.BBLayerManager;
import ru.blatfan.blatblock.common.data.BlatBlockLayer;
import ru.blatfan.blatblock.compat.jei.blocks.BBLBlocksCategory;
import ru.blatfan.blatblock.compat.jei.blocks.BBLBlocksWrapper;
import ru.blatfan.blatblock.compat.jei.entities.BBLEntitiesCategory;
import ru.blatfan.blatblock.compat.jei.entities.BBLEntitiesWrapper;

@JeiPlugin
public class BBJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return BlatBlock.loc("jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new BBLEntitiesCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BBLBlocksCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<BBLBlocksWrapper> recipesB = new ArrayList<BBLBlocksWrapper>();
        ArrayList<BBLEntitiesWrapper> recipesE = new ArrayList<BBLEntitiesWrapper>();
        ArrayList<ResourceLocation> sortedIds = new ArrayList<ResourceLocation>(BBLayerManager.getData().keySet());
        sortedIds.sort(Comparator.comparing(ResourceLocation::toString));
        for (ResourceLocation id : sortedIds) {
            BlatBlockLayer layer = BBLayerManager.get(id);
            TreeSet blockLevels = new TreeSet();
            layer.getBlocks().forEach(entry -> blockLevels.add(entry.level()));
            for (Integer lvl : blockLevels) {
                if (layer.getBlocks(lvl).isEmpty()) continue;
                recipesB.add(new BBLBlocksWrapper(id, lvl));
            }
            TreeSet entityLevels = new TreeSet();
            layer.getEntities().forEach(entry -> entityLevels.add(entry.level()));
            for (Integer lvl : entityLevels) {
                if (layer.getEntities(lvl).isEmpty()) continue;
                recipesE.add(new BBLEntitiesWrapper(id, lvl));
            }
        }
        registration.addRecipes(BBLBlocksCategory.TYPE, recipesB);
        registration.addRecipes(BBLEntitiesCategory.TYPE, recipesE);
        registration.addRecipes(BBLBlocksCategory.TYPE, recipesB);
        registration.addRecipes(BBLEntitiesCategory.TYPE, recipesE);
    }
}

