/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.compat.kubejs.bbl;

import dev.latvian.mods.rhino.util.HideFromJS;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import ru.blatfan.blatapi.utils.ColorHelper;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.common.data.BBLayerManager;
import ru.blatfan.blatblock.common.data.BlatBlockLayer;

public class BBLBuilder {
    private final ResourceLocation id;
    private Component displayName;
    private Color titleColor;
    private int blockCost;
    private final List<BlatBlockLayer.Entry> blocks;
    private final List<BlatBlockLayer.Entry> entities;
    private String blockcalc;
    private ResourceLocation texture;
    private ResourceLocation bg;
    private int sort;

    public BBLBuilder(ResourceLocation id) {
        this.id = id;
        this.displayName = Component.m_237113_((String)"Unnamed Layer");
        this.titleColor = Color.WHITE;
        this.blockCost = 0;
        this.blocks = new ArrayList<BlatBlockLayer.Entry>();
        this.entities = new ArrayList<BlatBlockLayer.Entry>();
        this.blockcalc = "1";
        this.texture = BlatBlock.loc("textures/gui/base.png");
        this.bg = null;
        this.sort = 0;
    }

    public BBLBuilder(BlatBlockLayer layer, ResourceLocation id) {
        this.id = id;
        this.displayName = layer.getTitle();
        this.titleColor = layer.getTitleColor();
        this.blockCost = layer.getBlockCost();
        this.blocks = layer.getBlocks();
        this.entities = layer.getEntities();
        this.blockcalc = layer.getBlockcalc();
        this.texture = layer.getTexture();
        this.bg = layer.getBg();
        this.sort = layer.getSort();
    }

    @HideFromJS
    public BlatBlockLayer create() {
        return new BlatBlockLayer(this.displayName, this.titleColor, this.blockCost, this.blocks, this.entities, this.blockcalc, this.texture, this.bg, this.sort);
    }

    public void register() {
        BBLayerManager.jsLayers.add(() -> this);
    }

    public BBLBuilder title(String title) {
        this.displayName = Component.m_237115_((String)title);
        return this;
    }

    public BBLBuilder titleColor(String hexColor) {
        this.titleColor = ColorHelper.getColor((String)hexColor);
        return this;
    }

    public BBLBuilder blockCost(int cost) {
        this.blockCost = cost;
        return this;
    }

    public BBLBuilder blockcalc(String formula) {
        this.blockcalc = formula;
        return this;
    }

    public BBLBuilder texture(String texture) {
        this.texture = new ResourceLocation(texture);
        return this;
    }

    public BBLBuilder background(String bg) {
        this.bg = new ResourceLocation(bg);
        return this;
    }

    public BBLBuilder sort(int sort) {
        this.sort = sort;
        return this;
    }

    public BBLBuilder block(String blockId, String chance) {
        return this.block(blockId, chance, 0);
    }

    public BBLBuilder block(String blockId, String chance, int level) {
        this.blocks.add(new BlatBlockLayer.Entry(new ResourceLocation(blockId), chance, level));
        return this;
    }

    public BBLBuilder blocks(Map<String, Object> blockMap) {
        blockMap.forEach((blockId, data) -> {
            if (data instanceof String) {
                String chance = (String)data;
                this.block((String)blockId, chance, 0);
            } else if (data instanceof Map) {
                Map blockData;
                Map bd = blockData = (Map)data;
                String chance = bd.getOrDefault("chance", "1.0").toString();
                int level = Integer.parseInt(((Object)bd.getOrDefault("level", 0)).toString());
                this.block((String)blockId, chance, level);
            }
        });
        return this;
    }

    public BBLBuilder entity(String entityId, String chance) {
        return this.entity(entityId, chance, 0);
    }

    public BBLBuilder entity(String entityId, String chance, int level) {
        this.entities.add(new BlatBlockLayer.Entry(new ResourceLocation(entityId), chance, level));
        return this;
    }

    public BBLBuilder entities(Map<String, Object> entityMap) {
        entityMap.forEach((entityId, data) -> {
            if (data instanceof String) {
                String chance = (String)data;
                this.entity((String)entityId, chance, 0);
            } else if (data instanceof Map) {
                Map entityData;
                Map ed = entityData = (Map)data;
                String chance = ed.getOrDefault("chance", "0.1").toString();
                int level = Integer.parseInt(((Object)ed.getOrDefault("level", 0)).toString());
                this.entity((String)entityId, chance, level);
            }
        });
        return this;
    }

    public ResourceLocation getId() {
        return this.id;
    }
}

