/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.common.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.common.data.BlatBlockLayer;

public class BlatBlockManager
extends SimpleJsonResourceReloadListener {
    public static final BlatBlockLayer NULL_BBL = new BlatBlockLayer((Component)Component.m_237113_((String)"NULL"), Color.RED, 0, new ArrayList<BlatBlockLayer.Entry>(), new ArrayList<BlatBlockLayer.Entry>(), "0", BlatBlock.loc("textures/gui/base.png"), null, 0);
    private static final Map<ResourceLocation, BlatBlockLayer> data = new ConcurrentHashMap<ResourceLocation, BlatBlockLayer>();
    private static ResourceLocation baseId;
    private static final Object reloadLock;
    private static final Gson GSON;

    public BlatBlockManager() {
        super(GSON, "blatblock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        Object object = reloadLock;
        synchronized (object) {
            HashMap<ResourceLocation, BlatBlockLayer> oldData = new HashMap<ResourceLocation, BlatBlockLayer>(data);
            ResourceLocation oldBaseId = baseId;
            data.clear();
            ResourceLocation newBaseId = null;
            int loadedCount = 0;
            int errorCount = 0;
            for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
                try {
                    if (entry.getValue() == null || !entry.getValue().isJsonObject()) {
                        throw new IllegalArgumentException("Invalid JSON structure");
                    }
                    BlatBlockLayer bbl = BlatBlockLayer.fromJson(entry.getValue());
                    if (bbl == null) {
                        throw new IllegalStateException("BlatBlockLayer.fromJson returned null");
                    }
                    data.put(entry.getKey(), bbl);
                    ++loadedCount;
                    if (bbl.getBlockCost() == -1 && newBaseId == null) {
                        newBaseId = entry.getKey();
                    }
                    BlatBlock.LOGGER.debug("Successfully loaded BlatBlockLayer: {}", (Object)entry.getKey());
                }
                catch (Exception e) {
                    ++errorCount;
                    BlatBlock.LOGGER.error("Failed to load BlatBlockLayer {}: {} - {}", new Object[]{entry.getKey(), e.getClass().getSimpleName(), e.getMessage()});
                    e.printStackTrace();
                }
            }
            if (loadedCount == 0) {
                BlatBlock.LOGGER.error("Failed to load any BlatBlockLayers! Restoring previous data...");
                data.putAll(oldData);
                baseId = oldBaseId;
            } else if (newBaseId != null) {
                baseId = newBaseId;
                BlatBlock.LOGGER.info("Set base BlatBlockLayer: {}", (Object)baseId);
            } else if (!data.isEmpty()) {
                baseId = data.keySet().iterator().next();
                BlatBlock.LOGGER.warn("No explicit base level found, using first available: {}", (Object)baseId);
            } else {
                baseId = BlatBlock.loc("null");
                BlatBlock.LOGGER.error("No valid base level found!");
            }
            if (errorCount > 0) {
                BlatBlock.LOGGER.warn("Loaded {} BlatBlockLayers with {} errors", (Object)loadedCount, (Object)errorCount);
            } else {
                BlatBlock.LOGGER.info("Successfully loaded {} BlatBlockLayers", (Object)loadedCount);
            }
        }
    }

    public static Map<ResourceLocation, BlatBlockLayer> getData() {
        return Collections.unmodifiableMap(data);
    }

    public static BlatBlockLayer get(ResourceLocation id) {
        return data.getOrDefault(id, NULL_BBL);
    }

    public static void add(ResourceLocation id, BlatBlockLayer layer) {
        if (data.containsKey(id)) {
            BlatBlockManager.remove(id);
        }
        data.put(id, layer);
    }

    public static void remove(ResourceLocation id) {
        if (!data.containsKey(id)) {
            return;
        }
        data.remove(id);
    }

    public static void removeAll() {
        data.clear();
    }

    public static ResourceLocation getBaseId() {
        ResourceLocation current = baseId;
        return current != null ? current : BlatBlock.loc("null");
    }

    public static Set<ResourceLocation> getAvailableIds() {
        return Collections.unmodifiableSet(data.keySet());
    }

    public static boolean hasLevel(ResourceLocation id) {
        return data.containsKey(id);
    }

    public static int getLevelCount() {
        return data.size();
    }

    static {
        reloadLock = new Object();
        GSON = new Gson();
    }
}

