/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.common.events;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import ru.blatfan.blatapi.common.player_stages.PlayerStages;
import ru.blatfan.blatapi.utils.LevelWorldUtil;
import ru.blatfan.blatapi.utils.NBTHelper;
import ru.blatfan.blatapi.utils.PlayerUtil;
import ru.blatfan.blatblock.common.BBRegistry;
import ru.blatfan.blatblock.common.block.blatgenerator.BlatGeneratorBlock;
import ru.blatfan.blatblock.common.data.BlatBlockLayer;
import ru.blatfan.blatblock.common.data.BlatBlockManager;
import ru.blatfan.blatblock.util.PlayerSettings;

public class GeneratorEvents {
    @SubscribeEvent
    public static void blockClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos clickPos = event.getPos();
        Level level = event.getEntity().m_9236_();
        Player player = event.getEntity();
        Block block = level.m_8055_(clickPos.m_7495_()).m_60734_();
        if (block instanceof BlatGeneratorBlock) {
            BlatGeneratorBlock generator = (BlatGeneratorBlock)block;
            if (!player.m_6144_()) {
                generator.m_6227_(level.m_8055_(clickPos.m_7495_()), level, clickPos.m_7495_(), event.getEntity(), event.getHand(), event.getHitVec());
            }
        }
    }

    @SubscribeEvent
    public static void blockDrop(BlockEvent.BreakEvent event) {
        BlockPos pos = event.getPos();
        Player player = event.getPlayer();
        Level level = player.m_9236_();
        BlockState gen = level.m_8055_(pos.m_7495_());
        BlockState state = event.getState();
        if (level.f_46443_) {
            return;
        }
        if (gen.m_60734_() instanceof BlatGeneratorBlock && !player.m_7500_() && (!state.m_60834_() || player.m_21205_().m_41735_(state))) {
            event.setCanceled(true);
            player.m_21205_().m_41686_(level, state, pos, player);
            level.m_46961_(pos, false);
            Item item = BlockItem.f_41373_.getOrDefault(state.m_60734_(), Items.f_41852_);
            ItemStack stack = new ItemStack((ItemLike)item);
            if (PlayerSettings.tagItem(player)) {
                NBTHelper.setString((ItemStack)stack, (String)"source", (String)"generator");
            }
            if (PlayerSettings.dropToInv(player)) {
                PlayerUtil.addItem((Player)player, (ItemStack)stack);
            } else {
                LevelWorldUtil.dropItemStackInWorld((Level)level, (BlockPos)pos.m_7918_(0, 1, 0), (ItemStack)stack);
            }
        }
    }

    @SubscribeEvent
    public static void genBlockTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (NBTHelper.hasKey((ItemStack)stack, (String)"source")) {
            event.getToolTip().add(Component.m_237110_((String)"tooltip.blatblock.source", (Object[])new Object[]{Component.m_237115_((String)("tooltip.blatblock.source." + NBTHelper.getString((ItemStack)stack, (String)"source"))).getString()}));
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel level = player2.m_284548_();
        if (GeneratorEvents.isEmptyVoidWorld(level)) {
            BlockPos generatorPos = new BlockPos(0, 0, 0);
            if (level.m_8055_(generatorPos).m_60795_()) {
                level.m_7731_(generatorPos, ((Block)BBRegistry.BLOCKS.BLAT_GENERATOR.get()).m_49966_(), 3);
                BlatBlockLayer bbl = BlatBlockManager.get(BlatBlockManager.getBaseId());
                BlockState state = bbl.getRandBlock(new Random(), 0);
                level.m_7731_(generatorPos.m_7918_(1, 0, 0), state, 3);
                level.m_7731_(generatorPos.m_7918_(-1, 0, 0), state, 3);
                level.m_7731_(generatorPos.m_7918_(0, 0, 1), state, 3);
                level.m_7731_(generatorPos.m_7918_(0, 0, -1), state, 3);
            }
            if (player2.m_20183_().m_123331_(Vec3i.f_123288_) > 100.0 && !PlayerStages.get((Player)player2, (String)"bb_first_join")) {
                player2.m_6021_(0.5, 2.0, 0.5);
                PlayerStages.add((Player)player2, (String)"bb_first_join");
                player2.m_7292_(new MobEffectInstance(MobEffects.f_19618_, 1200, 4, true, true, true));
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (GeneratorEvents.isEmptyVoidWorld(level)) {
            level.m_8733_(new BlockPos(0, 2, 0), 0.0f);
        }
    }

    private static boolean isEmptyVoidWorld(ServerLevel level) {
        ChunkGenerator generator = level.m_7726_().m_8481_();
        if (generator instanceof FlatLevelSource) {
            FlatLevelSource flatGen = (FlatLevelSource)generator;
            return flatGen.m_64191_().m_70401_().isEmpty();
        }
        return false;
    }
}

