/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.common.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.common.block.blatgenerator.BlatGeneratorBlockEntity;
import ru.blatfan.blatblock.common.data.BlatBlockManager;

public class BlatGeneratorPacket {
    private final int x;
    private final int y;
    private final int z;
    private final ResourceLocation bbl;
    private final Type type;

    public BlatGeneratorPacket(int x, int y, int z, ResourceLocation bbl, Type type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.bbl = bbl;
        this.type = type;
    }

    public BlatGeneratorPacket(BlockPos pos, ResourceLocation bbl, Type type) {
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.bbl = bbl;
        this.type = type;
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, BlatGeneratorPacket.class, BlatGeneratorPacket::encode, BlatGeneratorPacket::decode, BlatGeneratorPacket::handle);
    }

    public final void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().equals((Object)LogicalSide.SERVER)) {
                try {
                    Level level = ((NetworkEvent.Context)context.get()).getSender().m_9236_();
                    BlockEntity patt1848$temp = level.m_7702_(new BlockPos(this.x, this.y, this.z));
                    if (patt1848$temp instanceof BlatGeneratorBlockEntity) {
                        BlatGeneratorBlockEntity generator = (BlatGeneratorBlockEntity)patt1848$temp;
                        if (!level.f_46443_) {
                            if (generator.getAllMinedBlock() < BlatBlockManager.get(this.bbl).getBlockCost()) {
                                return;
                            }
                            if (this.type == Type.BUY) {
                                generator.setMinedBlock(this.bbl, 1);
                            }
                            generator.setCurrentBBLevel(this.bbl);
                            generator.m_6596_();
                        }
                    }
                }
                catch (Exception e) {
                    BlatBlock.LOGGER.error("Error handling BlatGenerator packet: {}", (Object)e.getMessage());
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.m_130070_(this.bbl.toString());
        buf.m_130068_((Enum)this.type);
    }

    public static BlatGeneratorPacket decode(FriendlyByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        ResourceLocation bbl = ResourceLocation.m_135820_((String)buf.m_130277_());
        Type type = (Type)buf.m_130066_(Type.class);
        return new BlatGeneratorPacket(x, y, z, bbl, type);
    }

    public static enum Type {
        SET,
        BUY;

    }
}

