/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.compat.jei;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.common.data.BlatBlockLayer;
import ru.blatfan.blatblock.common.data.BlatBlockManager;
import ru.blatfan.blatblock.compat.jei.blocks.BBLBlocksCategory;
import ru.blatfan.blatblock.compat.jei.blocks.BBLBlocksWrapper;
import ru.blatfan.blatblock.compat.jei.entities.BBLEntitiesCategory;
import ru.blatfan.blatblock.compat.jei.entities.BBLEntitiesWrapper;

@JeiPlugin
public class BBJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return BlatBlock.loc("jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new BBLEntitiesCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BBLBlocksCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        HashSet uniqueLevels;
        BlatBlockLayer bbl;
        ResourceLocation id;
        Map<ResourceLocation, BlatBlockLayer> data = BlatBlockManager.getData();
        ArrayList<BBLBlocksWrapper> recipesB = new ArrayList<BBLBlocksWrapper>();
        ArrayList<BBLEntitiesWrapper> recipesE = new ArrayList<BBLEntitiesWrapper>();
        for (Map.Entry<ResourceLocation, BlatBlockLayer> entry : data.entrySet()) {
            id = entry.getKey();
            bbl = entry.getValue();
            uniqueLevels = new HashSet();
            bbl.getBlocks().forEach(blockEntry -> uniqueLevels.add(blockEntry.level()));
            for (Integer level : uniqueLevels) {
                if (bbl.getBlocks(level).isEmpty()) continue;
                recipesB.add(new BBLBlocksWrapper(id, level));
            }
        }
        for (Map.Entry<ResourceLocation, BlatBlockLayer> entry : data.entrySet()) {
            id = entry.getKey();
            bbl = entry.getValue();
            uniqueLevels = new HashSet();
            bbl.getEntities().forEach(entityEntry -> uniqueLevels.add(entityEntry.level()));
            for (Integer level : uniqueLevels) {
                if (bbl.getEntities(level).isEmpty()) continue;
                recipesE.add(new BBLEntitiesWrapper(id, level));
            }
        }
        registration.addRecipes(BBLBlocksCategory.TYPE, recipesB);
        registration.addRecipes(BBLEntitiesCategory.TYPE, recipesE);
    }
}

