/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.compat.jei.entities;

import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import ru.blatfan.blatapi.client.guide_book.GuideClient;
import ru.blatfan.blatapi.utils.ClientTicks;
import ru.blatfan.blatapi.utils.GuiUtil;
import ru.blatfan.blatapi.utils.Text;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.client.gui.BlatBlockScreen;
import ru.blatfan.blatblock.compat.jei.BBLRecipe;

public class BBLEntitiesWrapper
extends BBLRecipe {
    public BBLEntitiesWrapper(ResourceLocation bbl, int level) {
        super(bbl, level);
    }

    public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
    }

    public List<Component> getTooltipStrings(double mX, double mY) {
        List<EntityType<?>> levelEntities = this.get().getEntities(this.getLevel());
        for (int i = 0; i < levelEntities.size(); ++i) {
            int x = i % 4;
            int blockX = 2 + x * 32;
            int y = i / 4;
            int blockY = 11 + y * 48;
            if (!BlatBlockScreen.isMouseOver(mX, mY, blockX, blockY, 16.0, 16.0)) continue;
            ArrayList<Component> tooltips = new ArrayList<Component>();
            EntityType<?> entityType = levelEntities.get(i);
            Entity fakeEntity = null;
            if (Minecraft.m_91087_().f_91073_ != null) {
                fakeEntity = entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_);
            }
            float chance = this.get().get(entityType).chance(this.getLevel());
            if (fakeEntity != null) {
                tooltips.add(fakeEntity.m_5446_());
            }
            tooltips.add((Component)Text.create((String)BuiltInRegistries.f_256780_.m_7981_(entityType).toString()).withColor(Color.DARK_GRAY));
            tooltips.add((Component)Text.create((String)"tooltip.blatblock.chance").add(String.format("%.1f%%", Float.valueOf(chance * 100.0f))));
            return tooltips;
        }
        return new ArrayList<Component>();
    }

    public void drawInfo(int recipeWidth, int recipeHeight, GuiGraphics gui, double mouseX, double mouseY) {
        int i;
        ResourceLocation texture = this.get().getTexture();
        boolean isMaxLevel = this.getLevel() >= 99;
        String levelText = isMaxLevel ? Component.m_237115_((String)"tooltip.blatblock.max").getString() : String.valueOf(this.getLevel() + 1);
        gui.m_280430_(GuideClient.font, (Component)Text.create((String)"tooltip.blatblock.level", (Object[])new Object[]{this.get().getTitle().getString(), levelText}).withColor(this.get().getTitleColor()).asComponent(), 0, 0, Color.WHITE.getRGB());
        List<EntityType<?>> levelEntities = this.get().getEntities(this.getLevel());
        for (i = 0; i < levelEntities.size(); ++i) {
            int x = i % 4;
            int y = i / 4;
            gui.m_280163_(texture, 1 + x * 32, 10 + y * 48, 32.0f, 0.0f, 32, 48, 64, 64);
        }
        for (i = 0; i < levelEntities.size(); ++i) {
            EntityType<?> entityType = levelEntities.get(i);
            if (Minecraft.m_91087_().f_91073_ == null) {
                return;
            }
            Entity entity = entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            int x = i % 4;
            int y = i / 4;
            living.f_20885_ = 0.0f;
            living.f_20886_ = 0.0f;
            float rotation = (float)ClientTicks.ticks + (float)(i * 10);
            try {
                GuiUtil.renderEntityQuaternionf((GuiGraphics)gui, (int)(16 + x * 32), (int)(48 + (living.m_20192_() > 2.0f ? 7 : 0) - (living.m_20192_() < 1.0f ? 7 : 0) + y * 48), (int)16, (Quaternionf)Axis.f_252436_.m_252977_(rotation), (Quaternionf)Axis.f_252529_.m_252977_(180.0f), (LivingEntity)living);
                continue;
            }
            catch (Exception e) {
                BlatBlock.LOGGER.warn("Failed to render entity {}: {}", (Object)entityType.m_20675_(), (Object)e.getMessage());
            }
        }
    }
}

