/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.common.block.autogenerator;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import ru.blatfan.blatapi.fluffy_fur.common.block.BlatEntityBlock;
import ru.blatfan.blatblock.common.block.autogenerator.AutoGeneratorBlockEntity;
import ru.blatfan.blatblock.common.block.autogenerator.AutoGeneratorMenu;

public class AutoGeneratorBlock
extends BlatEntityBlock {
    private final Type type;

    public AutoGeneratorBlock(Type type) {
        super(AutoGeneratorBlock.createProperties(type), AutoGeneratorBlockEntity::new);
        this.type = type;
    }

    private static BlockBehaviour.Properties createProperties(Type type) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(AutoGeneratorBlock.getMapColor(type)).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(AutoGeneratorBlock.getHardness(type), AutoGeneratorBlock.getResistance(type)).m_60918_(SoundType.f_56743_).m_60955_();
    }

    private static MapColor getMapColor(Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.BASIC, Type.PERFECT -> MapColor.f_283906_;
            case Type.IMPROVED -> MapColor.f_283821_;
        };
    }

    private static float getHardness(Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.BASIC -> 5.0f;
            case Type.IMPROVED -> 7.0f;
            case Type.PERFECT -> 10.0f;
        };
    }

    private static float getResistance(Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.BASIC -> 6.0f;
            case Type.IMPROVED -> 8.0f;
            case Type.PERFECT -> 12.0f;
        };
    }

    public static AutoGeneratorBlock basic() {
        return new AutoGeneratorBlock(Type.BASIC);
    }

    public static AutoGeneratorBlock improved() {
        return new AutoGeneratorBlock(Type.IMPROVED);
    }

    public static AutoGeneratorBlock perfect() {
        return new AutoGeneratorBlock(Type.PERFECT);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.f_46443_ && !pPlayer.m_6144_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)this.menuProvider(pPos), data -> {
                data.m_130064_(pPos);
                data.m_130068_((Enum)this.type);
            });
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return (level, pos, state, be) -> ((AutoGeneratorBlockEntity)be).tick(level, pos, this.type);
    }

    public MenuProvider menuProvider(final BlockPos pos) {
        return new MenuProvider(){

            public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
                return new AutoGeneratorMenu(pContainerId, pos, pPlayerInventory, AutoGeneratorBlock.this.type);
            }

            public Component m_5446_() {
                return AutoGeneratorBlock.this.m_49954_();
            }
        };
    }

    public static enum Type {
        BASIC,
        IMPROVED,
        PERFECT;

    }
}

