/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.common.block.autogenerator;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import ru.blatfan.blatapi.fluffy_fur.client.gui.screen.ContainerMenuBase;
import ru.blatfan.blatapi.fluffy_fur.client.gui.screen.ResultSlot;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.common.BBRegistry;
import ru.blatfan.blatblock.common.block.autogenerator.AutoGeneratorBlock;
import ru.blatfan.blatblock.common.block.autogenerator.AutoGeneratorBlockEntity;
import ru.blatfan.blatblock.common.block.autogenerator.GeneratorUpgradeSlot;

public class AutoGeneratorMenu
extends ContainerMenuBase {
    private final BlockEntity blockEntity;
    private final AutoGeneratorBlock.Type genType;
    private final ContainerData data;

    public AutoGeneratorMenu(int pContainerId, BlockPos pos, Inventory inventory, AutoGeneratorBlock.Type genType) {
        super((MenuType)BBRegistry.AUTO_GENERATOR_MENU.get(), pContainerId);
        this.playerInventory = new InvWrapper((Container)inventory);
        this.blockEntity = inventory.f_35978_.m_9236_().m_7702_(pos);
        this.genType = genType;
        BlockEntity blockEntity = this.blockEntity;
        if (blockEntity instanceof AutoGeneratorBlockEntity) {
            AutoGeneratorBlockEntity be = (AutoGeneratorBlockEntity)blockEntity;
            this.data = be.getData();
            Optional<ItemStackHandler> itemHandler = this.getItemHandlerSafe();
            if (itemHandler.isPresent()) {
                ItemStackHandler handler = itemHandler.get();
                BlatBlock.LOGGER.debug("ItemHandler has {} slots", (Object)handler.getSlots());
                if (handler.getSlots() >= 31) {
                    for (int i = 0; i < 27; ++i) {
                        this.m_38897_((Slot)new ResultSlot((IItemHandler)handler, i, 8 + i % 9 * 18, 18 + i / 9 * 18));
                    }
                    this.m_38897_((Slot)new GeneratorUpgradeSlot((IItemHandler)handler, 27, 178, 8));
                    this.m_38897_((Slot)new GeneratorUpgradeSlot((IItemHandler)handler, 28, 178, 26));
                    this.m_38897_((Slot)new GeneratorUpgradeSlot((IItemHandler)handler, 29, 178, 44));
                    this.m_38897_((Slot)new GeneratorUpgradeSlot((IItemHandler)handler, 30, 178, 62));
                } else {
                    BlatBlock.LOGGER.error("ItemHandler has only {} slots, but 31 are required", (Object)handler.getSlots());
                }
            } else {
                BlatBlock.LOGGER.error("BlockEntity does not have an ItemHandler capability");
            }
        } else {
            BlatBlock.LOGGER.error("BlockEntity at {} is not a AutoGeneratorBlockEntity", (Object)pos);
            this.data = new SimpleContainerData(2);
            this.data.m_8050_(0, 0);
            this.data.m_8050_(1, 1);
        }
        this.m_38884_(this.data);
        this.layoutPlayerInventorySlots(8, 86);
    }

    public int getProgress() {
        return this.data.m_6413_(0);
    }

    public int getProgressMax() {
        return this.data.m_6413_(1);
    }

    public Optional<ItemStackHandler> getItemHandlerSafe() {
        if (this.blockEntity == null) {
            return Optional.empty();
        }
        return this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().map(cap -> {
            if (cap instanceof ItemStackHandler) {
                return (ItemStackHandler)cap;
            }
            BlatBlock.LOGGER.warn("ItemHandler is not an instance of ItemStackHandler: {}", cap.getClass());
            return new ItemStackHandler(31);
        });
    }

    public int getInventorySize() {
        if (this.blockEntity == null) {
            return 0;
        }
        return this.getItemHandlerSafe().get().getSlots();
    }

    public boolean m_6875_(Player player) {
        if (this.blockEntity == null || this.blockEntity.m_58901_()) {
            return false;
        }
        BlockState state = this.blockEntity.m_58900_();
        double distance = player.m_20182_().m_82554_(this.blockEntity.m_58899_().m_252807_());
        boolean isValidState = ((BlockEntityType)BBRegistry.BLOCK_ENTITIES.AUTO_GENERATOR.get()).m_155262_(state);
        boolean isCloseEnough = distance < 9.0;
        return isValidState && isCloseEnough;
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public AutoGeneratorBlock.Type getGenType() {
        return this.genType;
    }

    public ContainerData getData() {
        return this.data;
    }
}

