/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.common.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import oshi.util.tuples.Pair;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.common.data.BlatBlockLayer;
import ru.blatfan.blatblock.compat.kubejs.BBKubeJSPlugin;
import ru.blatfan.blatblock.compat.kubejs.bbl.BBLBuilder;

public class BBLayerManager
extends SimpleJsonResourceReloadListener {
    public static final BlatBlockLayer NULL_BBL = new BlatBlockLayer((Component)Component.m_237113_((String)"NULL"), Color.RED, Integer.MAX_VALUE, new ArrayList<BlatBlockLayer.Entry>(), new ArrayList<BlatBlockLayer.Entry>(), "0", BlatBlock.loc("textures/gui/base.png"), null, 0);
    private static final Map<ResourceLocation, BlatBlockLayer> LAYERS = new ConcurrentHashMap<ResourceLocation, BlatBlockLayer>();
    public static final List<Supplier<BBLBuilder>> jsLayers = new ArrayList<Supplier<BBLBuilder>>();
    public static final List<ResourceLocation> removalBBL = new ArrayList<ResourceLocation>();
    public static final List<Pair<ResourceLocation, Pair<String, String>>> modifBBL = new ArrayList<Pair<ResourceLocation, Pair<String, String>>>();
    private static volatile ResourceLocation baseId;
    private static final Gson GSON;

    public BBLayerManager() {
        super(GSON, "blatblock");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonLayers, ResourceManager resourceManager, ProfilerFiller profiler) {
        LAYERS.clear();
        ResourceLocation newBase = null;
        if (ModList.get().isLoaded("kubejs")) {
            BBKubeJSPlugin.postBBL();
        }
        int loaded = 0;
        int errors = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonLayers.entrySet()) {
            ResourceLocation id = entry.getKey();
            if (removalBBL.contains(id)) continue;
            try {
                BlatBlockLayer layer = BlatBlockLayer.fromJson((JsonElement)entry.getValue().getAsJsonObject());
                boolean c = false;
                if (ModList.get().isLoaded("kubejs")) {
                    for (Pair<ResourceLocation, Pair<String, String>> modif : modifBBL) {
                        if (!((ResourceLocation)modif.getA()).equals((Object)id)) continue;
                        BBLBuilder builder = new BBLBuilder(layer, id);
                        builder.block((String)((Pair)modif.getB()).getA(), (String)((Pair)modif.getB()).getB());
                        jsLayers.add(() -> builder);
                        c = true;
                    }
                }
                if (c) continue;
                LAYERS.put(id, layer);
                ++loaded;
                if (layer.getBlockCost() != -1 || newBase != null) continue;
                newBase = id;
            }
            catch (Exception e) {
                ++errors;
                BlatBlock.LOGGER.error("Failed loading layer {}: {}", (Object)id, (Object)e.getMessage());
            }
        }
        if (ModList.get().isLoaded("kubejs")) {
            for (Supplier supplier : jsLayers) {
                BBLBuilder bblb = (BBLBuilder)supplier.get();
                ResourceLocation id = bblb.getId();
                if (removalBBL.contains(id)) continue;
                try {
                    if (ModList.get().isLoaded("kubejs")) {
                        for (Pair<ResourceLocation, Pair<String, String>> modif : modifBBL) {
                            if (!((ResourceLocation)modif.getA()).equals((Object)id)) continue;
                            bblb.block((String)((Pair)modif.getB()).getA(), (String)((Pair)modif.getB()).getB());
                        }
                    }
                    LAYERS.put(id, bblb.create());
                    ++loaded;
                    if (bblb.create().getBlockCost() != -1 || newBase != null) continue;
                    newBase = id;
                }
                catch (Exception e) {
                    ++errors;
                    BlatBlock.LOGGER.error("Failed loading js layer {}: {}", (Object)id, (Object)e.getMessage());
                }
            }
        }
        if (loaded == 0) {
            BlatBlock.LOGGER.error("No layers loaded from JSON, skipping baseId update");
        } else if (newBase != null) {
            baseId = newBase;
            BlatBlock.LOGGER.info("Base layer set: {}", newBase);
        } else {
            baseId = LAYERS.keySet().iterator().next();
            BlatBlock.LOGGER.warn("No explicit base, using first: {}", (Object)baseId);
        }
        BlatBlock.LOGGER.info("JSON reload complete: {} loaded, {} errors, {} total", new Object[]{loaded, errors, LAYERS.size()});
    }

    public static Map<ResourceLocation, BlatBlockLayer> getData() {
        return Collections.unmodifiableMap(new LinkedHashMap<ResourceLocation, BlatBlockLayer>(LAYERS));
    }

    public static BlatBlockLayer get(ResourceLocation id) {
        return LAYERS.getOrDefault(id, NULL_BBL);
    }

    public static ResourceLocation getBaseId() {
        ResourceLocation id = baseId;
        return id != null ? id : BlatBlock.loc("null");
    }

    public static Set<ResourceLocation> getAvailableIds() {
        return Collections.unmodifiableSet(new LinkedHashSet<ResourceLocation>(LAYERS.keySet()));
    }

    public static void setBaseId(ResourceLocation baseId) {
        BBLayerManager.baseId = baseId;
    }

    static {
        GSON = new Gson();
    }
}

