/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.common.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import ru.blatfan.blatapi.utils.ColorHelper;
import ru.blatfan.blatapi.utils.Text;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.util.MathEvaluator;
import ru.blatfan.blatblock.util.PlayerSettings;

public class BlatBlockLayer {
    private final Component title;
    private final Color titleColor;
    private final int blockCost;
    private final List<Entry> blocks;
    private final List<Entry> entities;
    private final String blockcalc;
    private final ResourceLocation texture;
    private final ResourceLocation bg;
    private final int sort;

    public static BlatBlockLayer fromJson(JsonElement element) {
        Entry entry;
        if (element == null || !element.isJsonObject()) {
            throw new IllegalArgumentException("Invalid JSON element for BlatBlockLayer");
        }
        JsonObject json = element.getAsJsonObject();
        ArrayList<Entry> blocks = new ArrayList<Entry>();
        ArrayList<Entry> entities = new ArrayList<Entry>();
        if (json.has("blocks") && json.get("blocks").isJsonArray()) {
            for (JsonElement blockEl : json.get("blocks").getAsJsonArray()) {
                try {
                    entry = BlatBlockLayer.parseBlockEntry(blockEl);
                    if (entry == null) continue;
                    blocks.add(entry);
                }
                catch (Exception e) {
                    BlatBlock.LOGGER.warn("Failed to parse block entry: {}", (Object)e.getMessage());
                }
            }
        }
        if (json.has("entities") && json.get("entities").isJsonArray()) {
            for (JsonElement entityEl : json.get("entities").getAsJsonArray()) {
                try {
                    entry = BlatBlockLayer.parseEntityEntry(entityEl);
                    if (entry == null) continue;
                    entities.add(entry);
                }
                catch (Exception e) {
                    BlatBlock.LOGGER.warn("Failed to parse entity entry: {}", (Object)e.getMessage());
                }
            }
        }
        int blockCost = json.has("block_cost") ? json.get("block_cost").getAsInt() : 0;
        String levelcalc = json.has("block_calc") ? json.get("block_calc").getAsString() : "level * 300";
        ResourceLocation texture = json.has("texture") ? ResourceLocation.m_135820_((String)json.get("texture").getAsString()) : BlatBlock.loc("textures/gui/base.png");
        ResourceLocation bg = json.has("background") ? ResourceLocation.m_135820_((String)json.get("background").getAsString()) : null;
        MutableComponent title = Text.create((String)json.get("title").getAsString()).asComponent();
        Color color = json.has("title_color") ? ColorHelper.getColor((String)json.get("title_color").getAsString()) : Color.WHITE;
        int sort = json.has("sort") ? json.get("sort").getAsInt() : 1;
        return new BlatBlockLayer((Component)title, color, blockCost, blocks, entities, levelcalc, texture, bg, sort);
    }

    public float calcBlocks(int level) {
        try {
            String expr = this.getBlockcalc();
            return (int)new MathEvaluator(expr).setVariable("level", level + 1).evaluate();
        }
        catch (Exception e) {
            BlatBlock.LOGGER.error("Error evaluating level formula '{}' : {}", (Object)this.getBlockcalc(), (Object)e.getMessage());
            return 0.0f;
        }
    }

    public Entry get(Block block) {
        for (Entry entry : this.blocks) {
            if (!entry.id().equals((Object)BuiltInRegistries.f_256975_.m_7981_((Object)block))) continue;
            return entry;
        }
        return null;
    }

    public Entry get(EntityType<?> entityType) {
        for (Entry entry : this.entities) {
            if (!entry.id().equals((Object)BuiltInRegistries.f_256780_.m_7981_(entityType))) continue;
            return entry;
        }
        return null;
    }

    private static Entry parseBlockEntry(JsonElement element) {
        int level;
        if (!element.isJsonObject()) {
            return null;
        }
        JsonObject obj = element.getAsJsonObject();
        if (!obj.has("block") || !obj.has("chance")) {
            return null;
        }
        String blockId = obj.get("block").getAsString();
        String chance = obj.get("chance").getAsString();
        int n = level = obj.has("level") ? obj.get("level").getAsInt() : 0;
        if (blockId.isEmpty() || chance.isEmpty() || level < 0) {
            return null;
        }
        return new Entry(new ResourceLocation(blockId), chance, level);
    }

    private static Entry parseEntityEntry(JsonElement element) {
        int level;
        if (!element.isJsonObject()) {
            return null;
        }
        JsonObject obj = element.getAsJsonObject();
        if (!obj.has("entity") || !obj.has("chance")) {
            return null;
        }
        String entityId = obj.get("entity").getAsString();
        String chance = obj.get("chance").getAsString();
        int n = level = obj.has("level") ? obj.get("level").getAsInt() : 0;
        if (entityId.isEmpty() || chance.isEmpty() || level < 0) {
            return null;
        }
        return new Entry(new ResourceLocation(entityId), chance, level);
    }

    public void rand(Player player, Level level, BlockPos pos, Random random, int blockLevel) {
        try {
            BlockState blockState = this.getRandBlock(random, blockLevel);
            if (blockState != null && blockState.m_60734_() instanceof LiquidBlock && !PlayerSettings.setLiquid(player)) {
                blockState = Blocks.f_50016_.m_49966_();
            }
            if (blockState != null) {
                level.m_7731_(pos, blockState, 3);
            }
        }
        catch (Exception e) {
            BlatBlock.LOGGER.error("Failed to set block at {}: {}", (Object)pos, (Object)e.getMessage());
        }
        EntityType<?> entityType = this.getRandEntity(random, blockLevel);
        if (entityType != null && PlayerSettings.spawnEntity(player)) {
            try {
                Entity entity = entityType.m_20615_(level);
                if (entity != null) {
                    Vec3 centerPos = pos.m_7494_().m_252807_();
                    entity.m_6034_(centerPos.f_82479_, centerPos.f_82480_, centerPos.f_82481_);
                    level.m_7967_(entity);
                }
            }
            catch (Exception e) {
                BlatBlock.LOGGER.error("Failed to spawn entity {} at {}: {}", new Object[]{entityType.m_20675_(), pos, e.getMessage()});
            }
        }
    }

    public BlockState getRandBlock(Random random, int blockLevel) {
        List<Entry> availableEntries = this.blocks.stream().filter(entry -> blockLevel >= entry.level).filter(entry -> BuiltInRegistries.f_256975_.m_7804_(entry.id)).toList();
        if (availableEntries.isEmpty()) {
            return Blocks.f_50016_.m_49966_();
        }
        float totalWeight = (float)availableEntries.stream().mapToDouble(e -> e.chance(blockLevel)).sum();
        if (totalWeight <= 0.0f) {
            return Blocks.f_50016_.m_49966_();
        }
        float randomValue = random.nextFloat() * totalWeight;
        float currentWeight = 0.0f;
        for (Entry entry2 : availableEntries) {
            if (!(randomValue <= (currentWeight += entry2.chance(blockLevel)))) continue;
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(entry2.id);
            return block.m_49966_();
        }
        Entry lastEntry = availableEntries.get(availableEntries.size() - 1);
        return ((Block)BuiltInRegistries.f_256975_.m_7745_(lastEntry.id)).m_49966_();
    }

    public EntityType<?> getRandEntity(Random random, int blockLevel) {
        float emptyWeight;
        List<Entry> availableEntries = this.entities.stream().filter(entry -> blockLevel >= entry.level).filter(entry -> BuiltInRegistries.f_256780_.m_7804_(entry.id)).toList();
        if (availableEntries.isEmpty()) {
            return null;
        }
        float totalWeight = (float)availableEntries.stream().mapToDouble(e -> e.chance(blockLevel)).sum();
        float totalWeightWithEmpty = totalWeight + (emptyWeight = totalWeight * 0.9f);
        if (totalWeightWithEmpty <= 0.0f) {
            return null;
        }
        float randomValue = random.nextFloat() * totalWeightWithEmpty;
        if (randomValue <= emptyWeight) {
            return null;
        }
        randomValue -= emptyWeight;
        float currentWeight = 0.0f;
        for (Entry entry2 : availableEntries) {
            if (!(randomValue <= (currentWeight += entry2.chance(blockLevel)))) continue;
            return (EntityType)BuiltInRegistries.f_256780_.m_7745_(entry2.id);
        }
        Entry lastEntry = availableEntries.get(availableEntries.size() - 1);
        return (EntityType)BuiltInRegistries.f_256780_.m_7745_(lastEntry.id);
    }

    public List<Block> getBlocks(int blockLevel) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Entry entry : this.blocks) {
            if (!BuiltInRegistries.f_256975_.m_7804_(entry.id) || entry.level > blockLevel || !(entry.chance(blockLevel) > 0.0f)) continue;
            blocks.add((Block)BuiltInRegistries.f_256975_.m_7745_(entry.id));
        }
        return blocks;
    }

    public List<EntityType<?>> getEntities(int blockLevel) {
        ArrayList entityTypes = new ArrayList();
        for (Entry entry : this.entities) {
            if (!BuiltInRegistries.f_256780_.m_7804_(entry.id) || entry.level > blockLevel || !(entry.chance(blockLevel) > 0.0f)) continue;
            entityTypes.add((EntityType)BuiltInRegistries.f_256780_.m_7745_(entry.id));
        }
        return entityTypes;
    }

    public BlatBlockLayer(Component title, Color titleColor, int blockCost, List<Entry> blocks, List<Entry> entities, String blockcalc, ResourceLocation texture, ResourceLocation bg, int sort) {
        this.title = title;
        this.titleColor = titleColor;
        this.blockCost = blockCost;
        this.blocks = blocks;
        this.entities = entities;
        this.blockcalc = blockcalc;
        this.texture = texture;
        this.bg = bg;
        this.sort = sort;
    }

    public Component getTitle() {
        return this.title;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public int getBlockCost() {
        return this.blockCost;
    }

    public List<Entry> getBlocks() {
        return this.blocks;
    }

    public List<Entry> getEntities() {
        return this.entities;
    }

    public String getBlockcalc() {
        return this.blockcalc;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ResourceLocation getBg() {
        return this.bg;
    }

    public int getSort() {
        return this.sort;
    }

    public record Entry(ResourceLocation id, String chanceFormul, int level) {
        public float chance(int level) {
            MathEvaluator evaluator = new MathEvaluator(this.chanceFormul).setVariable("level", level);
            return (float)Math.max(0.0, evaluator.evaluate());
        }
    }
}

