/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.compat.jei;

import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import ru.blatfan.blatblock.BlatBlock;
import ru.blatfan.blatblock.compat.jei.BBLRecipe;

public abstract class BlankJEIRecipeCategory<T extends BBLRecipe>
implements IRecipeCategory<T> {
    private final IDrawable icon;
    private final IDrawable bg;

    protected BlankJEIRecipeCategory(IGuiHelper guiHelper, ItemStack icon) {
        this.icon = guiHelper.createDrawableItemStack(icon);
        this.bg = guiHelper.createDrawable(BlatBlock.loc("textures/gui/jei.png"), 0, 0, 129, 132);
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        try {
            ((BBLRecipe)recipe).drawBg(guiGraphics);
            recipe.drawInfo(this.getBackground().getWidth(), this.getBackground().getHeight(), guiGraphics, mouseX, mouseY);
        }
        catch (Exception e) {
            BlatBlock.LOGGER.error("Error drawing JEI recipe: {}", (Object)e.getMessage());
        }
    }

    @NotNull
    public List<Component> getTooltipStrings(T recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        try {
            return recipe.getTooltipStrings(mouseX, mouseY);
        }
        catch (Exception e) {
            BlatBlock.LOGGER.error("Error getting JEI tooltip: {}", (Object)e.getMessage());
            return List.of();
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, -1000, -1000).addItemStack(ItemStack.f_41583_);
        ((BBLRecipe)recipe).addResultItems(builder);
    }
}

