/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.compat.jei.blocks;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import ru.blatfan.blatapi.client.guide_book.GuideClient;
import ru.blatfan.blatapi.client.render.FluidRenderMap;
import ru.blatfan.blatapi.utils.Text;
import ru.blatfan.blatblock.client.gui.BlatBlockScreen;
import ru.blatfan.blatblock.compat.jei.BBLRecipe;

public class BBLBlocksWrapper
extends BBLRecipe {
    public BBLBlocksWrapper(ResourceLocation bbl, int level) {
        super(bbl, level);
    }

    @Override
    public void addResultItems(IRecipeLayoutBuilder builder) {
        for (Block block : this.get().getBlocks(this.getLevel())) {
            ItemStack item = BlatBlockScreen.getItemStack(block);
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                try {
                    item = new ItemStack((ItemLike)liquidBlock.getFluid().m_6859_());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (item == null) continue;
            builder.addSlot(RecipeIngredientRole.OUTPUT, -1000, -1000).addItemStack(item);
        }
    }

    public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
    }

    public List<Component> getTooltipStrings(double mX, double mY) {
        List<Block> levelBlocks = this.get().getBlocks(this.getLevel());
        for (int i = 0; i < levelBlocks.size(); ++i) {
            int x = i % 7;
            int blockX = 2 + x * 18;
            int y = i / 7;
            int blockY = 11 + y * 18;
            if (!BlatBlockScreen.isMouseOver(mX, mY, blockX, blockY, 16.0, 16.0)) continue;
            Block block = levelBlocks.get(i);
            ItemStack item = BlatBlockScreen.getItemStack(block);
            float chance = this.get().get(block).chance(this.getLevel());
            if (item != null) {
                List tooltips = item.m_41651_(GuideClient.player, GuideClient.tooltipFlag);
                Item item2 = item.m_41720_();
                if (item2 instanceof BucketItem) {
                    BucketItem bucketItem = (BucketItem)item2;
                    tooltips.set(0, bucketItem.getFluid().getFluidType().getDescription());
                }
                tooltips.add(Text.create((String)"tooltip.blatblock.chance").add(String.format("%.1f%%", Float.valueOf(chance * 100.0f))));
                return tooltips;
            }
            if (!(block instanceof LiquidBlock)) continue;
            LiquidBlock liquidBlock = (LiquidBlock)block;
            ArrayList<Component> tooltips = new ArrayList<Component>();
            tooltips.add(liquidBlock.getFluid().getFluidType().getDescription());
            tooltips.add((Component)Text.create((String)BuiltInRegistries.f_257020_.m_7981_((Object)liquidBlock.getFluid()).toString()).withColor(Color.DARK_GRAY));
            tooltips.add((Component)Text.create((String)"tooltip.blatblock.chance").add(String.format("%.1f%%", Float.valueOf(chance * 100.0f))));
            return tooltips;
        }
        return new ArrayList<Component>();
    }

    public void drawInfo(int recipeWidth, int recipeHeight, GuiGraphics gui, double mouseX, double mouseY) {
        int y;
        int x;
        int i;
        ResourceLocation texture = this.get().getTexture();
        List<Block> levelBlocks = this.get().getBlocks(this.getLevel());
        boolean isMaxLevel = this.getLevel() >= 99;
        String levelText = isMaxLevel ? Component.m_237115_((String)"tooltip.blatblock.max").getString() : String.valueOf(this.getLevel() + 1);
        gui.m_280430_(GuideClient.font, (Component)Text.create((String)"tooltip.blatblock.level", (Object[])new Object[]{this.get().getTitle().getString(), levelText}).withColor(this.get().getTitleColor()).asComponent(), 0, 0, Color.WHITE.getRGB());
        for (i = 0; i < levelBlocks.size(); ++i) {
            x = i % 7;
            y = i / 7;
            gui.m_280163_(texture, 1 + x * 18, 10 + y * 18, 0.0f, 30.0f, 18, 18, 64, 64);
        }
        for (i = 0; i < levelBlocks.size(); ++i) {
            x = i % 7;
            y = i / 7;
            Block block = levelBlocks.get(i);
            ItemStack stack = BlatBlockScreen.getItemStack(block);
            if (stack != null) {
                gui.m_280480_(stack, 2 + x * 18, 11 + y * 18);
                gui.m_280370_(GuideClient.font, stack, 2 + x * 18, 2 + y * 18);
                continue;
            }
            if (!(block instanceof LiquidBlock)) continue;
            LiquidBlock liquidBlock = (LiquidBlock)block;
            try {
                TextureAtlasSprite sprite = FluidRenderMap.getCachedFluidTexture((FluidStack)new FluidStack(liquidBlock.getFluid().m_5613_(), 1000), (FluidRenderMap.FluidFlow)FluidRenderMap.FluidFlow.STILL);
                if (liquidBlock.getFluid().m_5613_() == Fluids.f_76193_) {
                    RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                }
                gui.m_280159_(2 + x * 18, 11 + y * 18, 0, 16, 16, sprite);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                continue;
            }
            catch (Exception e) {
                gui.m_280509_(2 + x * 18, 11 + y * 18, 2 + x * 18 + 16, 2 + y * 18 + 16, -1);
            }
        }
    }
}

