/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatblock.util;

import java.util.HashMap;
import java.util.Map;

public class MathEvaluator {
    private final String expression;
    private int pos;
    private char currentChar;
    private final Map<String, Double> variables;

    public MathEvaluator(String expression) {
        this.expression = expression.replaceAll("\\s", "");
        this.pos = 0;
        this.currentChar = !expression.isEmpty() ? expression.charAt(0) : (char)'\u0000';
        this.variables = new HashMap<String, Double>();
        this.setVariable("PI", Math.PI);
    }

    public MathEvaluator setVariable(String name, double value) {
        this.variables.put(name, value);
        return this;
    }

    public double evaluate() {
        double result = this.parseExpression();
        if (this.pos < this.expression.length()) {
            throw new IllegalArgumentException("Unexpected symbols: " + this.expression.substring(this.pos));
        }
        return result;
    }

    private void nextChar() {
        ++this.pos;
        this.currentChar = this.pos < this.expression.length() ? this.expression.charAt(this.pos) : (char)'\u0000';
    }

    private boolean consume(char expected) {
        if (this.currentChar == expected) {
            this.nextChar();
            return true;
        }
        return false;
    }

    private double parseExpression() {
        double result = this.parseTerm();
        while (this.currentChar == '+' || this.currentChar == '-') {
            char op = this.currentChar;
            this.nextChar();
            double term = this.parseTerm();
            if (op == '+') {
                result += term;
                continue;
            }
            result -= term;
        }
        return result;
    }

    private double parseTerm() {
        double result = this.parseFactor();
        while (this.currentChar == '*' || this.currentChar == '/' || this.currentChar == '%') {
            char op = this.currentChar;
            this.nextChar();
            double factor = this.parseFactor();
            if (op == '*') {
                result *= factor;
                continue;
            }
            if (factor == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            if (op == '/') {
                result /= factor;
                continue;
            }
            result %= factor;
        }
        return result;
    }

    private double parseFactor() {
        if (this.consume('-')) {
            return -this.parseFactor();
        }
        if (this.consume('+')) {
            return this.parseFactor();
        }
        if (this.consume('(')) {
            double result = this.parseExpression();
            if (!this.consume(')')) {
                throw new IllegalArgumentException("Expected ')'");
            }
            return result;
        }
        if (Character.isLetter(this.currentChar)) {
            StringBuilder name = new StringBuilder();
            while (Character.isLetterOrDigit(this.currentChar) || this.currentChar == '_') {
                name.append(this.currentChar);
                this.nextChar();
            }
            if (this.consume('(')) {
                double arg = this.parseExpression();
                if (!this.consume(')')) {
                    throw new IllegalArgumentException("Expected ')' after the function argument");
                }
                return this.evaluateFunction(name.toString(), arg);
            }
            String varName = name.toString();
            if (!this.variables.containsKey(varName)) {
                throw new IllegalArgumentException("An undefined variable: " + varName);
            }
            return this.variables.get(varName);
        }
        if (Character.isDigit(this.currentChar) || this.currentChar == '.') {
            return this.parseNumber();
        }
        throw new IllegalArgumentException("Unexpected symbols: " + this.currentChar);
    }

    private double parseNumber() {
        StringBuilder sb = new StringBuilder();
        while (Character.isDigit(this.currentChar) || this.currentChar == '.') {
            sb.append(this.currentChar);
            this.nextChar();
        }
        try {
            return Double.parseDouble(sb.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Incorrect number: " + sb);
        }
    }

    private double evaluateFunction(String funcName, double arg) {
        return switch (funcName) {
            case "sin" -> Math.sin(arg);
            case "cos" -> Math.cos(arg);
            case "tan" -> Math.tan(arg);
            case "sqrt" -> Math.sqrt(arg);
            case "abs" -> Math.abs(arg);
            case "log" -> Math.log(arg);
            case "exp" -> Math.exp(arg);
            default -> throw new IllegalArgumentException("Unknown function: " + funcName);
        };
    }
}

