/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.chestsorter.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.shweit.chestsorter.ChestSorter;
import com.shweit.chestsorter.PlayerData;
import com.shweit.chestsorter.sorting.SortHelper;
import com.shweit.chestsorter.sorting.SortOrder;
import com.shweit.chestsorter.sorting.SortType;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.BlockPositionResolver;
import io.papermc.paper.math.BlockPosition;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class SortCommands {
    private static final SuggestionProvider<CommandSourceStack> SORT_TYPE_SUGGESTIONS = (context, builder) -> {
        builder.suggest("NAME");
        builder.suggest("QUANTITY");
        builder.suggest("MATERIAL_TYPE");
        builder.suggest("DURABILITY");
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> SORT_ORDER_SUGGESTIONS = (context, builder) -> {
        builder.suggest("ASC");
        builder.suggest("DESC");
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> PLAYER_SUGGESTIONS = (context, builder) -> {
        Bukkit.getOnlinePlayers().forEach(p -> builder.suggest(p.getName()));
        return builder.buildFuture();
    };

    public static LiteralArgumentBuilder<CommandSourceStack> createSortContainerCommand(ChestSorter plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sortcontainer").requires(ctx -> ctx.getSender() instanceof Player && ctx.getSender().hasPermission("chestsorter.sort.container"))).executes(ctx -> SortCommands.executeSortContainerRaytrace((CommandContext<CommandSourceStack>)ctx, plugin))).then(((RequiredArgumentBuilder)Commands.argument((String)"containerPosition", (ArgumentType)ArgumentTypes.blockPosition()).executes(ctx -> SortCommands.executeSortContainerWithPosition((CommandContext<CommandSourceStack>)ctx, plugin, null, null))).then(((RequiredArgumentBuilder)Commands.argument((String)"sortType", (ArgumentType)StringArgumentType.word()).suggests(SORT_TYPE_SUGGESTIONS).executes(ctx -> SortCommands.executeSortContainerWithPosition((CommandContext<CommandSourceStack>)ctx, plugin, StringArgumentType.getString((CommandContext)ctx, (String)"sortType"), null))).then(Commands.argument((String)"sortOrder", (ArgumentType)StringArgumentType.word()).suggests(SORT_ORDER_SUGGESTIONS).executes(ctx -> SortCommands.executeSortContainerWithPosition((CommandContext<CommandSourceStack>)ctx, plugin, StringArgumentType.getString((CommandContext)ctx, (String)"sortType"), StringArgumentType.getString((CommandContext)ctx, (String)"sortOrder"))))));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> createSortPlayerCommand(ChestSorter plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sortplayer").requires(ctx -> ctx.getSender() instanceof Player && ctx.getSender().hasPermission("chestsorter.sort.player.self"))).executes(ctx -> SortCommands.executeSortPlayerSelf((CommandContext<CommandSourceStack>)ctx, plugin))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests(PLAYER_SUGGESTIONS).requires(ctx -> ctx.getSender().hasPermission("chestsorter.sort.player.others"))).executes(ctx -> SortCommands.executeSortPlayerOther((CommandContext<CommandSourceStack>)ctx, plugin, StringArgumentType.getString((CommandContext)ctx, (String)"player"), null, null))).then(((RequiredArgumentBuilder)Commands.argument((String)"sortType", (ArgumentType)StringArgumentType.word()).suggests(SORT_TYPE_SUGGESTIONS).executes(ctx -> SortCommands.executeSortPlayerOther((CommandContext<CommandSourceStack>)ctx, plugin, StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"sortType"), null))).then(Commands.argument((String)"sortOrder", (ArgumentType)StringArgumentType.word()).suggests(SORT_ORDER_SUGGESTIONS).executes(ctx -> SortCommands.executeSortPlayerOther((CommandContext<CommandSourceStack>)ctx, plugin, StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"sortType"), StringArgumentType.getString((CommandContext)ctx, (String)"sortOrder"))))));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> createSortPrefsCommand(ChestSorter plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sortprefs").requires(ctx -> ctx.getSender() instanceof Player)).executes(ctx -> SortCommands.executeSortPrefsShow((CommandContext<CommandSourceStack>)ctx, plugin))).then(Commands.literal((String)"toggle").executes(ctx -> SortCommands.executeSortPrefsToggle((CommandContext<CommandSourceStack>)ctx, plugin)))).then(Commands.literal((String)"type").then(Commands.argument((String)"sortType", (ArgumentType)StringArgumentType.word()).suggests(SORT_TYPE_SUGGESTIONS).executes(ctx -> SortCommands.executeSortPrefsType((CommandContext<CommandSourceStack>)ctx, plugin, StringArgumentType.getString((CommandContext)ctx, (String)"sortType")))))).then(Commands.literal((String)"order").then(Commands.argument((String)"sortOrder", (ArgumentType)StringArgumentType.word()).suggests(SORT_ORDER_SUGGESTIONS).executes(ctx -> SortCommands.executeSortPrefsOrder((CommandContext<CommandSourceStack>)ctx, plugin, StringArgumentType.getString((CommandContext)ctx, (String)"sortOrder")))));
    }

    private static int executeSortContainerRaytrace(CommandContext<CommandSourceStack> ctx, ChestSorter plugin) {
        PlayerData playerData;
        PlayerData.PlayerSettings settings;
        Player player = (Player)((CommandSourceStack)ctx.getSource()).getSender();
        SortHelper helper = plugin.getSortHelper();
        boolean success = helper.sortContainerByRayTrace(player, (settings = (playerData = plugin.getPlayerData()).getSettings(player)).getDefaultSortType(), settings.getDefaultSortOrder());
        return success ? 1 : 0;
    }

    private static int executeSortContainerWithPosition(CommandContext<CommandSourceStack> ctx, ChestSorter plugin, String sortTypeStr, String sortOrderStr) {
        Player player = (Player)((CommandSourceStack)ctx.getSource()).getSender();
        SortHelper helper = plugin.getSortHelper();
        PlayerData playerData = plugin.getPlayerData();
        PlayerData.PlayerSettings settings = playerData.getSettings(player);
        try {
            BlockPositionResolver posResolver = (BlockPositionResolver)ctx.getArgument("containerPosition", BlockPositionResolver.class);
            BlockPosition blockPos = (BlockPosition)posResolver.resolve((CommandSourceStack)ctx.getSource());
            Location location = new Location(((CommandSourceStack)ctx.getSource()).getLocation().getWorld(), (double)blockPos.blockX(), (double)blockPos.blockY(), (double)blockPos.blockZ());
            SortType type = sortTypeStr != null ? SortType.fromString(sortTypeStr) : settings.getDefaultSortType();
            SortOrder order = sortOrderStr != null ? SortOrder.fromString(sortOrderStr) : settings.getDefaultSortOrder();
            boolean success = helper.sortContainer(player, location, type, order);
            return success ? 1 : 0;
        }
        catch (CommandSyntaxException e) {
            String message = Objects.requireNonNullElse(plugin.getConfig().getString("messages.invalid-location", "Invalid location specified."), "Invalid location specified.");
            player.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
            return 0;
        }
    }

    private static int executeSortPlayerSelf(CommandContext<CommandSourceStack> ctx, ChestSorter plugin) {
        PlayerData playerData;
        PlayerData.PlayerSettings settings;
        Player player = (Player)((CommandSourceStack)ctx.getSource()).getSender();
        SortHelper helper = plugin.getSortHelper();
        boolean success = helper.sortPlayer(player, player, (settings = (playerData = plugin.getPlayerData()).getSettings(player)).getDefaultSortType(), settings.getDefaultSortOrder());
        return success ? 1 : 0;
    }

    private static int executeSortPlayerOther(CommandContext<CommandSourceStack> ctx, ChestSorter plugin, String targetName, String sortTypeStr, String sortOrderStr) {
        Player player = (Player)((CommandSourceStack)ctx.getSource()).getSender();
        SortHelper helper = plugin.getSortHelper();
        PlayerData playerData = plugin.getPlayerData();
        PlayerData.PlayerSettings settings = playerData.getSettings(player);
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            String message = Objects.requireNonNullElse(plugin.getConfig().getString("messages.player-not-found", "Player not found."), "Player not found.");
            player.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
            return 0;
        }
        SortType type = sortTypeStr != null ? SortType.fromString(sortTypeStr) : settings.getDefaultSortType();
        SortOrder order = sortOrderStr != null ? SortOrder.fromString(sortOrderStr) : settings.getDefaultSortOrder();
        boolean success = helper.sortPlayer(player, target, type, order);
        return success ? 1 : 0;
    }

    private static int executeSortPrefsShow(CommandContext<CommandSourceStack> ctx, ChestSorter plugin) {
        Player player = (Player)((CommandSourceStack)ctx.getSource()).getSender();
        PlayerData playerData = plugin.getPlayerData();
        PlayerData.PlayerSettings settings = playerData.getSettings(player);
        String message = Objects.requireNonNullElse(plugin.getConfig().getString("messages.prefs-info", "&7ChestSorter settings: &e%enabled% &7| Type: &e%type% &7| Order: &e%order%"), "&7ChestSorter settings: &e%enabled% &7| Type: &e%type% &7| Order: &e%order%");
        message = message.replace("%enabled%", settings.isEnabled() ? "ENABLED" : "DISABLED").replace("%type%", settings.getDefaultSortType().name()).replace("%order%", settings.getDefaultSortOrder().name());
        TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
        player.sendMessage((Component)component);
        return 1;
    }

    private static int executeSortPrefsToggle(CommandContext<CommandSourceStack> ctx, ChestSorter plugin) {
        PlayerData.PlayerSettings settings;
        Player player = (Player)((CommandSourceStack)ctx.getSource()).getSender();
        PlayerData playerData = plugin.getPlayerData();
        settings.setEnabled(!(settings = playerData.getSettings(player)).isEnabled());
        playerData.saveSettings(player.getUniqueId(), settings);
        String messageKey = settings.isEnabled() ? "messages.prefs-enabled" : "messages.prefs-disabled";
        String defaultMsg = settings.isEnabled() ? "&aChestSorter enabled!" : "&cChestSorter disabled! Use &e/sortprefs toggle &cto re-enable.";
        String message = Objects.requireNonNullElse(plugin.getConfig().getString(messageKey, defaultMsg), defaultMsg);
        TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
        player.sendMessage((Component)component);
        return 1;
    }

    private static int executeSortPrefsType(CommandContext<CommandSourceStack> ctx, ChestSorter plugin, String sortTypeStr) {
        Player player = (Player)((CommandSourceStack)ctx.getSource()).getSender();
        PlayerData playerData = plugin.getPlayerData();
        PlayerData.PlayerSettings settings = playerData.getSettings(player);
        SortType sortType = SortType.fromString(sortTypeStr);
        if (sortType == null) {
            String message = Objects.requireNonNullElse(plugin.getConfig().getString("messages.invalid-sort-type", "Invalid sort type. Available: NAME, QUANTITY, MATERIAL_TYPE, DURABILITY"), "Invalid sort type. Available: NAME, QUANTITY, MATERIAL_TYPE, DURABILITY");
            player.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
            return 0;
        }
        settings.setDefaultSortType(sortType);
        playerData.saveSettings(player.getUniqueId(), settings);
        String message = Objects.requireNonNullElse(plugin.getConfig().getString("messages.prefs-updated", "&aSort preferences updated!"), "&aSort preferences updated!");
        TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
        player.sendMessage((Component)component);
        return 1;
    }

    private static int executeSortPrefsOrder(CommandContext<CommandSourceStack> ctx, ChestSorter plugin, String sortOrderStr) {
        Player player = (Player)((CommandSourceStack)ctx.getSource()).getSender();
        PlayerData playerData = plugin.getPlayerData();
        PlayerData.PlayerSettings settings = playerData.getSettings(player);
        SortOrder sortOrder = SortOrder.fromString(sortOrderStr);
        if (sortOrder == null) {
            String message = Objects.requireNonNullElse(plugin.getConfig().getString("messages.invalid-sort-order", "Invalid sort order. Use ASC or DESC"), "Invalid sort order. Use ASC or DESC");
            player.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
            return 0;
        }
        settings.setDefaultSortOrder(sortOrder);
        playerData.saveSettings(player.getUniqueId(), settings);
        String message = Objects.requireNonNullElse(plugin.getConfig().getString("messages.prefs-updated", "&aSort preferences updated!"), "&aSort preferences updated!");
        TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
        player.sendMessage((Component)component);
        return 1;
    }
}

