/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.chestsorter.listeners;

import com.shweit.chestsorter.ChestSorter;
import com.shweit.chestsorter.PlayerData;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerJoinListener
implements Listener {
    private final ChestSorter plugin;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Plugin instance is intentionally shared in Bukkit plugins")
    public PlayerJoinListener(ChestSorter plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        PlayerData playerData = this.plugin.getPlayerData();
        PlayerData.PlayerSettings settings = playerData.getSettings(player);
        if (!settings.hasSeenWelcome()) {
            String welcomeMessage = this.plugin.getConfig().getString("messages.welcome", "&6Welcome to the Server! Use /sortprefs to customize settings.");
            if (welcomeMessage != null) {
                TextComponent message = LegacyComponentSerializer.legacyAmpersand().deserialize(welcomeMessage);
                player.sendMessage((Component)message);
            }
            playerData.markWelcomeSeen(player);
        }
    }
}

