/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.chestsorter;

import com.shweit.chestsorter.PlayerData;
import com.shweit.chestsorter.commands.SortCommands;
import com.shweit.chestsorter.listeners.MiddleClickSortListener;
import com.shweit.chestsorter.listeners.PlayerJoinListener;
import com.shweit.chestsorter.listeners.SneakSortListener;
import com.shweit.chestsorter.sorting.SortHelper;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import shadow.io.papermc.paperlib.PaperLib;

public class ChestSorter
extends JavaPlugin {
    private SortHelper sortHelper;
    private PlayerData playerData;

    public void onEnable() {
        PaperLib.suggestPaper((Plugin)this);
        this.saveDefaultConfig();
        this.sortHelper = new SortHelper(this);
        this.playerData = new PlayerData(this);
        this.registerCommands();
        this.registerListeners();
        this.getLogger().info("ChestSorter enabled successfully!");
    }

    public SortHelper getSortHelper() {
        return this.sortHelper;
    }

    public PlayerData getPlayerData() {
        return this.playerData;
    }

    private void registerCommands() {
        LifecycleEventManager manager = this.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            commands.register(SortCommands.createSortContainerCommand(this).build());
            commands.register(SortCommands.createSortPlayerCommand(this).build());
            commands.register(SortCommands.createSortPrefsCommand(this).build());
        });
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new SneakSortListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MiddleClickSortListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
    }
}

