/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.chestsorter;

import com.shweit.chestsorter.ChestSorter;
import com.shweit.chestsorter.sorting.SortOrder;
import com.shweit.chestsorter.sorting.SortType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerData {
    private final ChestSorter plugin;
    private final File dataFile;
    private FileConfiguration data;
    private final Map<UUID, PlayerSettings> cache;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Plugin instance is intentionally shared in Bukkit plugins")
    public PlayerData(ChestSorter plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "players.yml");
        this.cache = new HashMap<UUID, PlayerSettings>();
        this.loadData();
    }

    private void loadData() {
        if (!this.dataFile.exists()) {
            this.plugin.saveResource("players.yml", false);
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public void saveData() {
        try {
            this.data.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save players.yml: " + e.getMessage());
        }
    }

    public PlayerSettings getSettings(Player player) {
        return this.getSettings(player.getUniqueId());
    }

    public PlayerSettings getSettings(UUID uuid) {
        if (this.cache.containsKey(uuid)) {
            return this.cache.get(uuid);
        }
        String key = uuid.toString();
        boolean enabled = this.data.getBoolean(key + ".enabled", true);
        boolean hasSeenWelcome = this.data.getBoolean(key + ".has-seen-welcome", false);
        String sortTypeStr = this.data.getString(key + ".default-sort-type");
        String sortOrderStr = this.data.getString(key + ".default-sort-order");
        SortType sortType = sortTypeStr != null ? SortType.fromString(sortTypeStr) : null;
        SortOrder sortOrder = sortOrderStr != null ? SortOrder.fromString(sortOrderStr) : null;
        PlayerSettings settings = new PlayerSettings(enabled, sortType, sortOrder, hasSeenWelcome);
        this.cache.put(uuid, settings);
        return settings;
    }

    public void saveSettings(UUID uuid, PlayerSettings settings) {
        String key = uuid.toString();
        this.data.set(key + ".enabled", (Object)settings.isEnabled());
        this.data.set(key + ".has-seen-welcome", (Object)settings.hasSeenWelcome());
        this.data.set(key + ".default-sort-type", settings.getDefaultSortType() != null ? settings.getDefaultSortType().name() : null);
        this.data.set(key + ".default-sort-order", settings.getDefaultSortOrder() != null ? settings.getDefaultSortOrder().name() : null);
        this.cache.put(uuid, settings);
        this.saveData();
    }

    public void markWelcomeSeen(Player player) {
        PlayerSettings settings = this.getSettings(player);
        settings.setHasSeenWelcome(true);
        this.saveSettings(player.getUniqueId(), settings);
    }

    public static class PlayerSettings {
        private boolean enabled;
        private SortType defaultSortType;
        private SortOrder defaultSortOrder;
        private boolean hasSeenWelcome;

        public PlayerSettings(boolean enabled, SortType defaultSortType, SortOrder defaultSortOrder, boolean hasSeenWelcome) {
            this.enabled = enabled;
            this.defaultSortType = defaultSortType;
            this.defaultSortOrder = defaultSortOrder;
            this.hasSeenWelcome = hasSeenWelcome;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public SortType getDefaultSortType() {
            return this.defaultSortType;
        }

        public void setDefaultSortType(SortType defaultSortType) {
            this.defaultSortType = defaultSortType;
        }

        public SortOrder getDefaultSortOrder() {
            return this.defaultSortOrder;
        }

        public void setDefaultSortOrder(SortOrder defaultSortOrder) {
            this.defaultSortOrder = defaultSortOrder;
        }

        public boolean hasSeenWelcome() {
            return this.hasSeenWelcome;
        }

        public void setHasSeenWelcome(boolean hasSeenWelcome) {
            this.hasSeenWelcome = hasSeenWelcome;
        }
    }
}

