/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.chestsorter.listeners;

import com.shweit.chestsorter.ChestSorter;
import com.shweit.chestsorter.PlayerData;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class MiddleClickSortListener
implements Listener {
    private final ChestSorter plugin;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Plugin instance is intentionally shared in Bukkit plugins")
    public MiddleClickSortListener(ChestSorter plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!this.plugin.getConfig().getBoolean("middle-click.enabled")) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!player.hasPermission("chestsorter.middleclick.sort")) {
            return;
        }
        PlayerData playerData = this.plugin.getPlayerData();
        PlayerData.PlayerSettings settings = playerData.getSettings(player);
        if (!settings.isEnabled()) {
            return;
        }
        if (event.getClick() != ClickType.MIDDLE) {
            return;
        }
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        InventoryHolder holder = clickedInventory.getHolder();
        if (holder == null || holder instanceof Player) {
            return;
        }
        if (holder instanceof BlockState) {
            BlockState blockState = (BlockState)holder;
            Block block = blockState.getBlock();
            Location location = block.getLocation();
            if (this.plugin.getSortHelper().isBlacklisted(location)) {
                return;
            }
            String blockKey = block.getType().getKey().toString();
            if (this.plugin.getConfig().getStringList("blacklist.container-types").contains(blockKey)) {
                return;
            }
        }
        event.setCancelled(true);
        this.plugin.getSortHelper().sortInventory(clickedInventory, settings.getDefaultSortType(), settings.getDefaultSortOrder());
        String message = Objects.requireNonNullElse(this.plugin.getConfig().getString("messages.sort-success", "Container sorted successfully!"), "Container sorted successfully!");
        player.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.GREEN));
        this.plugin.getSortHelper().playSuccessSound(player);
    }
}

