/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.chestsorter.listeners;

import com.shweit.chestsorter.ChestSorter;
import com.shweit.chestsorter.PlayerData;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class SneakSortListener
implements Listener {
    private final ChestSorter plugin;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Plugin instance is intentionally shared in Bukkit plugins")
    public SneakSortListener(ChestSorter plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.plugin.getConfig().getBoolean("sneak-sort.enabled")) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("chestsorter.sneak.sort")) {
            return;
        }
        PlayerData playerData = this.plugin.getPlayerData();
        PlayerData.PlayerSettings settings = playerData.getSettings(player);
        if (!settings.isEnabled()) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        BlockState state = block.getState();
        if (!(state instanceof InventoryHolder)) {
            return;
        }
        InventoryHolder holder = (InventoryHolder)state;
        Location location = block.getLocation();
        if (this.plugin.getSortHelper().isBlacklisted(location)) {
            return;
        }
        String blockKey = block.getType().getKey().toString();
        if (this.plugin.getConfig().getStringList("blacklist.container-types").contains(blockKey)) {
            return;
        }
        event.setCancelled(true);
        Inventory inventory = holder.getInventory();
        this.plugin.getSortHelper().sortInventory(inventory, settings.getDefaultSortType(), settings.getDefaultSortOrder());
        String message = Objects.requireNonNullElse(this.plugin.getConfig().getString("messages.sort-success", "Container sorted successfully!"), "Container sorted successfully!");
        player.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.GREEN));
        this.plugin.getSortHelper().playSuccessSound(player);
    }
}

