/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.chestsorter.sorting;

import com.shweit.chestsorter.sorting.SortOrder;
import com.shweit.chestsorter.sorting.SortType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Comparator;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class InventorySorter {
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Defensive null check for safety")
    public void sortInventory(Inventory inventory, SortType sortType, SortOrder sortOrder) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack[] contents = inventory.getContents();
        if (contents == null) {
            return;
        }
        for (ItemStack item : contents) {
            if (item == null || item.getType() == Material.AIR) continue;
            items.add(item.clone());
        }
        Comparator<ItemStack> comparator = this.getComparator(sortType);
        if (sortOrder == SortOrder.DESC) {
            comparator = comparator.reversed();
        }
        items.sort(comparator);
        inventory.clear();
        for (int i = 0; i < items.size() && i < inventory.getSize(); ++i) {
            inventory.setItem(i, (ItemStack)items.get(i));
        }
    }

    private Comparator<ItemStack> getComparator(SortType sortType) {
        return switch (sortType) {
            default -> throw new MatchException(null, null);
            case SortType.NAME -> Comparator.comparing(item -> item.getType().name());
            case SortType.QUANTITY -> Comparator.comparingInt(ItemStack::getAmount);
            case SortType.MATERIAL_TYPE -> Comparator.comparing(item -> this.getMaterialCategory(item.getType())).thenComparing(item -> item.getType().name());
            case SortType.DURABILITY -> Comparator.comparingInt(this::getDurabilityValue).thenComparing(item -> item.getType().name());
        };
    }

    private String getMaterialCategory(Material material) {
        if (material.isBlock()) {
            if (this.isOre(material)) {
                return "A_ORE";
            }
            if (this.isWood(material)) {
                return "B_WOOD";
            }
            if (this.isStone(material)) {
                return "C_STONE";
            }
            if (material.name().contains("GLASS")) {
                return "D_GLASS";
            }
            if (material.name().contains("WOOL") || material.name().contains("CARPET")) {
                return "E_WOOL";
            }
            if (material.name().contains("CONCRETE")) {
                return "F_CONCRETE";
            }
            return "G_BLOCK";
        }
        if (material.isEdible()) {
            return "H_FOOD";
        }
        if (this.isTool(material)) {
            return "I_TOOL";
        }
        if (this.isArmor(material)) {
            return "J_ARMOR";
        }
        if (this.isWeapon(material)) {
            return "K_WEAPON";
        }
        return "Z_OTHER";
    }

    private boolean isOre(Material material) {
        String name = material.name();
        return name.contains("_ORE") || name.contains("RAW_");
    }

    private boolean isWood(Material material) {
        String name = material.name();
        return name.contains("_LOG") || name.contains("_WOOD") || name.contains("_PLANKS");
    }

    private boolean isStone(Material material) {
        String name = material.name();
        return name.contains("STONE") || name.contains("COBBLESTONE") || name.contains("ANDESITE") || name.contains("DIORITE") || name.contains("GRANITE");
    }

    private boolean isTool(Material material) {
        String name = material.name();
        return name.contains("_PICKAXE") || name.contains("_AXE") || name.contains("_SHOVEL") || name.contains("_HOE");
    }

    private boolean isArmor(Material material) {
        String name = material.name();
        return name.contains("_HELMET") || name.contains("_CHESTPLATE") || name.contains("_LEGGINGS") || name.contains("_BOOTS");
    }

    private boolean isWeapon(Material material) {
        String name = material.name();
        return name.contains("_SWORD") || name.equals("BOW") || name.equals("CROSSBOW") || name.equals("TRIDENT");
    }

    private int getDurabilityValue(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta instanceof Damageable) {
            Damageable damageable = (Damageable)itemMeta;
            Material type = item.getType();
            short maxDurability = type.getMaxDurability();
            if (maxDurability > 0) {
                return maxDurability - damageable.getDamage();
            }
        }
        return Integer.MAX_VALUE;
    }
}

