/*
 * Decompiled with CFR 0.152.
 */
package com.shweit.chestsorter.sorting;

import com.shweit.chestsorter.ChestSorter;
import com.shweit.chestsorter.sorting.InventorySorter;
import com.shweit.chestsorter.sorting.SortOrder;
import com.shweit.chestsorter.sorting.SortType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class SortHelper {
    private final ChestSorter plugin;
    private final InventorySorter sorter;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Plugin instance is intentionally shared in Bukkit plugins")
    public SortHelper(ChestSorter plugin) {
        this.plugin = plugin;
        this.sorter = new InventorySorter();
    }

    public boolean sortContainer(Player player, Location location, SortType sortType, SortOrder sortOrder) {
        Block block = location.getBlock();
        BlockState state = block.getState();
        if (!(state instanceof InventoryHolder)) {
            String message = Objects.requireNonNullElse(this.plugin.getConfig().getString("messages.invalid-location", "The target block is not a container."), "The target block is not a container.");
            player.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
            return false;
        }
        InventoryHolder holder = (InventoryHolder)state;
        String locationKey = String.format("%s:%d:%d:%d", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
        if (this.plugin.getConfig().getStringList("blacklist.locations").contains(locationKey)) {
            String message = Objects.requireNonNullElse(this.plugin.getConfig().getString("messages.blacklisted", "This container is blacklisted from sorting."), "This container is blacklisted from sorting.");
            player.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
            return false;
        }
        String blockKey = block.getType().getKey().toString();
        if (this.plugin.getConfig().getStringList("blacklist.container-types").contains(blockKey)) {
            String message = Objects.requireNonNullElse(this.plugin.getConfig().getString("messages.blacklisted", "This container type is blacklisted from sorting."), "This container type is blacklisted from sorting.");
            player.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
            return false;
        }
        if (sortType == null) {
            sortType = SortType.fromString(this.plugin.getConfig().getString("default-sort-type", "NAME"));
        }
        if (sortOrder == null) {
            sortOrder = SortOrder.fromString(this.plugin.getConfig().getString("default-sort-order", "ASC"));
        }
        if (sortType == null) {
            String message = Objects.requireNonNullElse(this.plugin.getConfig().getString("messages.invalid-sort-type", "Invalid sort type. Available: NAME, QUANTITY, MATERIAL_TYPE, DURABILITY"), "Invalid sort type. Available: NAME, QUANTITY, MATERIAL_TYPE, DURABILITY");
            player.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
            return false;
        }
        if (sortOrder == null) {
            String message = Objects.requireNonNullElse(this.plugin.getConfig().getString("messages.invalid-sort-order", "Invalid sort order. Use ASC or DESC"), "Invalid sort order. Use ASC or DESC");
            player.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
            return false;
        }
        this.sorter.sortInventory(holder.getInventory(), sortType, sortOrder);
        String message = Objects.requireNonNullElse(this.plugin.getConfig().getString("messages.sort-success", "Container sorted successfully!"), "Container sorted successfully!");
        player.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.GREEN));
        this.playSuccessSound(player);
        return true;
    }

    public boolean sortContainerByRayTrace(Player player, SortType sortType, SortOrder sortOrder) {
        Block block = player.getTargetBlockExact(5);
        if (block == null) {
            String message = Objects.requireNonNullElse(this.plugin.getConfig().getString("messages.invalid-location", "No container found. Please look at a container or specify coordinates."), "No container found. Please look at a container or specify coordinates.");
            player.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
            return false;
        }
        return this.sortContainer(player, block.getLocation(), sortType, sortOrder);
    }

    public boolean sortPlayer(Player executor, Player target, SortType sortType, SortOrder sortOrder) {
        if (sortType == null) {
            sortType = SortType.fromString(this.plugin.getConfig().getString("default-sort-type", "NAME"));
        }
        if (sortOrder == null) {
            sortOrder = SortOrder.fromString(this.plugin.getConfig().getString("default-sort-order", "ASC"));
        }
        if (sortType == null) {
            String message = Objects.requireNonNullElse(this.plugin.getConfig().getString("messages.invalid-sort-type", "Invalid sort type. Available: NAME, QUANTITY, MATERIAL_TYPE, DURABILITY"), "Invalid sort type. Available: NAME, QUANTITY, MATERIAL_TYPE, DURABILITY");
            executor.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
            return false;
        }
        if (sortOrder == null) {
            String message = Objects.requireNonNullElse(this.plugin.getConfig().getString("messages.invalid-sort-order", "Invalid sort order. Use ASC or DESC"), "Invalid sort order. Use ASC or DESC");
            executor.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
            return false;
        }
        this.sorter.sortInventory((Inventory)target.getInventory(), sortType, sortOrder);
        String message = target.equals((Object)executor) ? Objects.requireNonNullElse(this.plugin.getConfig().getString("messages.sort-player-success", "Inventory sorted successfully!"), "Inventory sorted successfully!") : Objects.requireNonNullElse(this.plugin.getConfig().getString("messages.sort-other-success", "Sorted %player%'s inventory!"), "Sorted %player%'s inventory!").replace("%player%", target.getName());
        executor.sendActionBar((Component)Component.text((String)message, (TextColor)NamedTextColor.GREEN));
        this.playSuccessSound(executor);
        return true;
    }

    public void sortInventory(Inventory inventory, SortType sortType, SortOrder sortOrder) {
        if (sortType == null) {
            sortType = SortType.fromString(this.plugin.getConfig().getString("default-sort-type", "NAME"));
        }
        if (sortOrder == null) {
            sortOrder = SortOrder.fromString(this.plugin.getConfig().getString("default-sort-order", "ASC"));
        }
        if (sortType != null && sortOrder != null) {
            this.sorter.sortInventory(inventory, sortType, sortOrder);
        }
    }

    public boolean isBlacklisted(Location location) {
        String locationKey = String.format("%s:%d:%d:%d", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
        return this.plugin.getConfig().getStringList("blacklist.locations").contains(locationKey);
    }

    public void playSuccessSound(Player player) {
        if (!this.plugin.getConfig().getBoolean("sound.enabled", true)) {
            return;
        }
        String soundName = this.plugin.getConfig().getString("sound.success", "ITEM_BOOK_PAGE_TURN");
        if (soundName == null) {
            soundName = "ITEM_BOOK_PAGE_TURN";
        }
        float volume = (float)this.plugin.getConfig().getDouble("sound.volume", 0.5);
        float pitch = (float)this.plugin.getConfig().getDouble("sound.pitch", 1.0);
        try {
            Sound sound = Sound.valueOf((String)soundName);
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid sound configured: " + soundName);
        }
    }
}

