/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.mutechatplus;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MuteChatPlus
extends JavaPlugin
implements Listener {
    private boolean chatMuted = false;
    private List<UUID> bypassPlayers = new ArrayList<UUID>();
    private String mutedChatMessage;
    private String chatMutedMessage;
    private String chatUnmutedMessage;
    private String noPermissionMessage;
    private String bypassEnabledMessage;
    private String bypassDisabledMessage;
    private String bypassAddedMessage;
    private String bypassRemovedMessage;
    private String playerNotFoundMessage;
    private boolean useMutedChatPrefix;
    private String mutedChatPrefix;
    private boolean notifyStaffOnBypassChat;
    private String bypassChatNotification;
    private String bypassPermission;
    private String mutePermission;
    private String bypassAddRemovePermission;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("mutechat").setExecutor(new MuteChatCommand());
        this.getCommand("bypasschat").setExecutor(new BypassChatCommand());
        this.getCommand("unbypasschat").setExecutor(new UnBypassChatCommand());
        this.getLogger().info("MuteChatPlus has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("MuteChatPlus has been disabled!");
    }

    private void loadConfig() {
        this.mutedChatMessage = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("messages.muted-chat"));
        this.chatMutedMessage = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("messages.chat-muted"));
        this.chatUnmutedMessage = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("messages.chat-unmuted"));
        this.noPermissionMessage = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("messages.no-permission"));
        this.bypassEnabledMessage = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("messages.bypass-enabled"));
        this.bypassDisabledMessage = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("messages.bypass-disabled"));
        this.bypassAddedMessage = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("messages.bypass-added"));
        this.bypassRemovedMessage = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("messages.bypass-removed"));
        this.playerNotFoundMessage = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("messages.player-not-found"));
        this.useMutedChatPrefix = this.getConfig().getBoolean("features.use-muted-chat-prefix");
        this.mutedChatPrefix = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("features.muted-chat-prefix"));
        this.notifyStaffOnBypassChat = this.getConfig().getBoolean("features.notify-staff-on-bypass-chat");
        this.bypassChatNotification = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("messages.bypass-chat-notification"));
        this.bypassPermission = this.getConfig().getString("permissions.bypass");
        this.mutePermission = this.getConfig().getString("permissions.mute");
        this.bypassAddRemovePermission = this.getConfig().getString("permissions.manage-bypass");
    }

    public void reloadPluginConfig() {
        this.reloadConfig();
        this.loadConfig();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.chatMuted && !player.hasPermission(this.bypassPermission) && !this.bypassPlayers.contains(player.getUniqueId())) {
            event.setCancelled(true);
            player.sendMessage(this.mutedChatMessage);
            return;
        }
        if (this.chatMuted && (player.hasPermission(this.bypassPermission) || this.bypassPlayers.contains(player.getUniqueId()))) {
            if (this.useMutedChatPrefix) {
                event.setFormat(this.mutedChatPrefix + event.getFormat());
            }
            if (this.notifyStaffOnBypassChat) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    for (Player player2 : Bukkit.getOnlinePlayers()) {
                        if (!player2.hasPermission(this.mutePermission) || player2.equals(player)) continue;
                        player2.sendMessage(String.format(this.bypassChatNotification, player.getName(), event.getMessage()));
                    }
                });
            }
        }
    }

    private class MuteChatCommand
    implements CommandExecutor {
        private MuteChatCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!sender.hasPermission(MuteChatPlus.this.mutePermission)) {
                sender.sendMessage(MuteChatPlus.this.noPermissionMessage);
                return true;
            }
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                MuteChatPlus.this.reloadPluginConfig();
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "MuteChatPlus configuration reloaded!");
                return true;
            }
            MuteChatPlus.this.chatMuted = !MuteChatPlus.this.chatMuted;
            String message = MuteChatPlus.this.chatMuted ? MuteChatPlus.this.chatMutedMessage : MuteChatPlus.this.chatUnmutedMessage;
            Bukkit.broadcastMessage(message);
            return true;
        }
    }

    private class BypassChatCommand
    implements CommandExecutor {
        private BypassChatCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (args.length == 0) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "This command can only be used by players!");
                    return true;
                }
                Player player = (Player)sender;
                if (!player.hasPermission(MuteChatPlus.this.bypassPermission)) {
                    player.sendMessage(MuteChatPlus.this.noPermissionMessage);
                    return true;
                }
                UUID playerId = player.getUniqueId();
                if (MuteChatPlus.this.bypassPlayers.contains(playerId)) {
                    MuteChatPlus.this.bypassPlayers.remove(playerId);
                    player.sendMessage(MuteChatPlus.this.bypassDisabledMessage);
                } else {
                    MuteChatPlus.this.bypassPlayers.add(playerId);
                    player.sendMessage(MuteChatPlus.this.bypassEnabledMessage);
                }
                return true;
            }
            if (!sender.hasPermission(MuteChatPlus.this.bypassAddRemovePermission)) {
                sender.sendMessage(MuteChatPlus.this.noPermissionMessage);
                return true;
            }
            Player target = Bukkit.getPlayer(args[0]);
            if (target == null) {
                sender.sendMessage(MuteChatPlus.this.playerNotFoundMessage);
                return true;
            }
            UUID targetId = target.getUniqueId();
            if (!MuteChatPlus.this.bypassPlayers.contains(targetId)) {
                MuteChatPlus.this.bypassPlayers.add(targetId);
                sender.sendMessage(String.format(MuteChatPlus.this.bypassAddedMessage, target.getName()));
                target.sendMessage(MuteChatPlus.this.bypassEnabledMessage);
            } else {
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + target.getName() + " already has chat bypass enabled!");
            }
            return true;
        }
    }

    private class UnBypassChatCommand
    implements CommandExecutor {
        private UnBypassChatCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!sender.hasPermission(MuteChatPlus.this.bypassAddRemovePermission)) {
                sender.sendMessage(MuteChatPlus.this.noPermissionMessage);
                return true;
            }
            if (args.length == 0) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /unbypasschat <player>");
                return true;
            }
            Player target = Bukkit.getPlayer(args[0]);
            if (target == null) {
                sender.sendMessage(MuteChatPlus.this.playerNotFoundMessage);
                return true;
            }
            UUID targetId = target.getUniqueId();
            if (MuteChatPlus.this.bypassPlayers.contains(targetId)) {
                MuteChatPlus.this.bypassPlayers.remove(targetId);
                sender.sendMessage(String.format(MuteChatPlus.this.bypassRemovedMessage, target.getName()));
                target.sendMessage(MuteChatPlus.this.bypassDisabledMessage);
            } else {
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + target.getName() + " does not have chat bypass enabled!");
            }
            return true;
        }
    }
}

