#version 330 compatibility

uniform sampler2D colortex0;
uniform sampler2D depthtex0;

uniform float far;
uniform vec3 fogColor;
uniform bool hasSkylight;
uniform int isEyeInWater;

uniform mat4 gbufferProjectionInverse;

in vec2 texcoord;

vec3 projectAndDivide(mat4 projectionMatrix, vec3 position){
    vec4 homPos = projectionMatrix * vec4(position, 1.0);
    return homPos.xyz / homPos.w;
}

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 color;

void main() {
    color = texture(colortex0, texcoord);

    float depth = texture(depthtex0, texcoord).r;

    if (depth == 1.0) {
        if (!hasSkylight) {
            vec3 skyFog = vec3(dot(fogColor, vec3(0.2126, 0.7152, 0.0722)));
            color = vec4(pow(skyFog, vec3(2.2)), 1.0);
        }
        if (hasSkylight) return;
    }

    vec3 NDCPos = vec3(texcoord.xy, depth) * 2.0 - 1.0;
    vec3 viewPos = projectAndDivide(gbufferProjectionInverse, NDCPos);

    float dist;
    float fogFactor;
    vec3 finalFog;

    if (isEyeInWater == 1) {
        dist = length(viewPos) / (far * 0.5);
        fogFactor = exp(-1.0 * (1.0 - dist));
        finalFog = pow((hasSkylight ? fogColor : fogColor) * vec3(0.0, 0.2, 0.3), vec3(2.2));
    } else if (isEyeInWater == 2) {
        dist = length(viewPos) / (far * 0.1);
        fogFactor = exp(-1.0 * (1.0 - dist));
        finalFog = pow((hasSkylight ? fogColor : fogColor) * vec3(1.0, 0.5, 0.0), vec3(2.2));
    } else if (isEyeInWater == 3) {
        dist = length(viewPos) / 8.0;
        fogFactor = exp(-1.0 * (1.0 - dist));
        finalFog = pow((hasSkylight ? fogColor : fogColor) * vec3(0.9, 0.9, 1.0), vec3(2.2));
    } else {
        dist = length(viewPos) / far;
        fogFactor = exp(-8.0 * (1.0 - dist));
        finalFog = pow((hasSkylight ? fogColor : fogColor), vec3(2.2));
    }

    color.rgb = mix(color.rgb, finalFog, clamp(fogFactor, 0.0, 1.0));
}