#version 330 compatibility

uniform sampler2D colortex0;
uniform sampler2D depthtex0;
uniform float far;
uniform int isEyeInWater;
uniform mat4 gbufferProjectionInverse;

in vec2 texcoord;
layout(location = 0) out vec4 color;

vec3 projectAndDivide(mat4 projectionMatrix, vec3 position){
    vec4 h = projectionMatrix * vec4(position, 1.0);
    return h.xyz / h.w;
}

const vec3 fogColor = vec3(0.2, 0.0, 0.6);

void main(){
    color = texture(colortex0, texcoord);
    float depth = texture(depthtex0, texcoord).r;
    if(depth == 1.0) return;
    if(isEyeInWater == 1) return;

    vec3 NDCPos = vec3(texcoord.xy, depth) * 2.0 - 1.0;
    vec3 viewPos = projectAndDivide(gbufferProjectionInverse, NDCPos);
    float dist = length(viewPos) / far;
    float expFactor = (isEyeInWater == 2 || isEyeInWater == 3) ? -2.0 : -6.0;
    float fogFactor = clamp(exp(expFactor * (1.0 - dist)), 0.0, 1.0);

    vec3 finalFog = pow(fogColor, vec3(2.2));
    color.rgb = mix(color.rgb, finalFog, fogFactor);
}
