#version 330 compatibility

uniform sampler2D colortex0;
uniform sampler2D depthtex0;

uniform float viewHeight;
uniform float viewWidth;
uniform mat4 gbufferModelView;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferProjection;
uniform vec3 sunPosition;

in vec2 texcoord;

const vec3 fogColor = vec3(0.2, 0.0, 0.6);
const vec3 skyColor = vec3(0.0, 0.0, 0.2);

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 color;

float fogify(float x, float w) {
    return w / (x * x + w);
}

vec3 screenToView(vec3 screenPos) {
    vec4 ndcPos = vec4(screenPos * 2.0 - 1.0, 1.0);
    vec4 tmp = gbufferProjectionInverse * ndcPos;
    return tmp.xyz / tmp.w;
}

void main() {
    color = texture(colortex0, texcoord);

    float depth = texture(depthtex0, texcoord).r;
    if (depth == 1.0) {
        vec2 screenUV = gl_FragCoord.xy / vec2(viewWidth, viewHeight);
        vec3 pos = normalize(screenToView(vec3(screenUV, 1.0)));

        float upDot = dot(pos, gbufferModelView[1].xyz);
        vec3 baseColor = mix(skyColor + vec3(0.0, 0.0, 0.3) , skyColor, upDot);
        vec3 col = mix(baseColor, fogColor, fogify(max(upDot, 0.0), 0.1));
        
        vec4 sunClip = gbufferProjection * vec4(sunPosition, 1.0);
        vec2 diff = screenUV - (sunClip.xy / sunClip.w * 0.5 + 0.5);
        diff.x *= viewWidth / viewHeight;
        col += vec3(0.6, 0.3, 0.2) * exp(-length(diff) * 3.0);
        
        color = vec4(pow(col, vec3(2.2)), 0.0);
    }
}