#version 330 compatibility

/*
const int colortex0Format = RGB16F;
*/

#define BRIGHTNESS 1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

uniform sampler2D colortex0;

in vec2 texcoord;

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 color;

const vec3 gamma = vec3(0.45454545);
const vec3 gray = vec3(0.2126, 0.7152, 0.0722);
const float brightness = BRIGHTNESS;

vec3 tonemap(vec3 x) {
    const float a = 3.0;
    const float b = 0.1;
    const float c = 2.5;
    const float d = 1.0;
    const float e = 0.35;
    
    vec3 x2 = x * x;
    return clamp((x * (a * x + b)) / (x2 * c + x * d + e), 0.0, 1.0);
}

void main() {
    vec3 hdrColor = pow(texture(colortex0, texcoord).rgb, gamma) * brightness;  
    hdrColor = tonemap(hdrColor);
    color = vec4(hdrColor, 1.0);
}