#version 330 compatibility

uniform float viewHeight;
uniform float viewWidth;
uniform float rainStrength;

uniform mat4 gbufferModelView;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferProjection;

uniform vec3 sunPosition;

uniform int renderStage;
uniform int worldTime;

in vec4 glcolor;

const int times[6] = int[](0, 6000, 12785, 18000, 23215, 24000);

const vec3 skyValues[6] = vec3[](vec3(0.2, 0.3, 0.4), vec3(0.1, 0.2, 0.4), vec3(0.0, 0.05, 0.2), vec3(0.0, 0.05, 0.1), vec3(0.0, 0.0, 0.1), vec3(0.2, 0.3, 0.4));
const vec3 horizonValues[6] = vec3[](vec3(0.5, 0.4, 0.4), vec3(0.25, 0.4, 0.45), vec3(0.1, 0.25, 0.3), vec3(0.0, 0.1, 0.2), vec3(0.1, 0.25, 0.3), vec3(0.5, 0.4, 0.4));
const vec3 fogValues[6] = vec3[](vec3(0.9, 0.8, 0.7), vec3(0.8, 0.8, 0.8), vec3(0.35, 0.25, 0.2), vec3(0.15, 0.15, 0.15), vec3(0.35, 0.25, 0.2), vec3(0.9, 0.8, 0.7));
const vec3 glowValues[6] = vec3[](vec3(1.0, 0.6, 0.3), vec3(0.8, 0.5, 0.2), vec3(0.3, 0.1, 0.05), vec3(0.1, 0.05, 0.1), vec3(0.3, 0.1, 0.05), vec3(1.0, 0.6, 0.3));

layout(location = 0) out vec4 color;

void main() {
	if (renderStage == MC_RENDER_STAGE_STARS) {
		color = glcolor * 0.5;
		return;
	}

	vec2 screenUV = gl_FragCoord.xy / vec2(viewWidth, viewHeight);
	vec4 ndcPos = vec4(screenUV, 1.0, 1.0) * 2.0 - 1.0;
	vec4 tmp = gbufferProjectionInverse * ndcPos;
	vec3 pos = normalize(tmp.xyz / tmp.w);

	vec3 skyColor = vec3(0.0);
	vec3 fogColor = vec3(0.0);
	vec3 glowColor = vec3(0.0);
	vec3 horizonColor = vec3(0.0);

	for (int i = 0; i < 5; i++) {
		if (worldTime >= times[i] && worldTime < times[i + 1]) {
			float t = float(worldTime - times[i]) / float(times[i + 1] - times[i]);
			skyColor = mix(skyValues[i], skyValues[i + 1],t);
			fogColor = mix(fogValues[i], fogValues[i + 1],t);
			glowColor = mix(glowValues[i], glowValues[i + 1],t) * (1.5 - rainStrength);
			horizonColor = mix(horizonValues[i], horizonValues[i + 1],t);
			break;
		}
	}

	float upDot = dot(pos, gbufferModelView[1].xyz);
	vec3 baseColor = mix(horizonColor, skyColor, upDot);
	float fogFactor = 0.025 / (max(upDot, 0.0) * max(upDot, 0.0) + 0.025);
	vec3 col = mix(baseColor, fogColor, fogFactor);
	
	vec4 sunClip = gbufferProjection * vec4(sunPosition, 1.0);
	vec2 diff = screenUV - (sunClip.xy / sunClip.w) * 0.5 - 0.5;
	diff.x *= viewWidth / viewHeight;
	col += glowColor * exp(-length(diff) * 6.0);
	
	color = vec4(pow(col, vec3(2.2)), 0.0);
}