#version 330 compatibility

#define REFLECTION_INTENSITY 1.0 // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

uniform sampler2D colortex0;
uniform sampler2D colortex2;
uniform sampler2D colortex4;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;

const float intensity = 0.2 * REFLECTION_INTENSITY;

in vec2 texcoord;

layout(location = 0) out vec4 color;

void main() {
    if (REFLECTION_INTENSITY == 0.0) discard;
    vec3 base = texture(colortex0, texcoord).rgb;
    vec2 normal = texture(colortex2, texcoord).xy * 2.0 - 1.0;
    float mask = texture(colortex4, texcoord).r;
    
    float d0 = texture(depthtex0, texcoord).r;
    if (d0 == 1.0) discard;
    
    float d1 = texture(depthtex1, texcoord).r;
    float tolerance = 0.1;
    if (d0 == d1 && abs(mask - 1.0) > tolerance) discard;

    vec2 reflUV = clamp(vec2(texcoord.x + normal.x * 0.1, 1.0 - texcoord.y - normal.y * 0.1), 0.0, 1.0);
    vec3 reflection = texture(colortex0, reflUV).rgb;

    color = vec4(mix(base, reflection, intensity), 1.0);
}