#version 330 compatibility

uniform sampler2D colortex0;
uniform sampler2D depthtex0;
uniform float far;
uniform int isEyeInWater;
uniform int worldTime;
uniform mat4 gbufferProjectionInverse;

in vec2 texcoord;
layout(location = 0) out vec4 color;

vec3 projectAndDivide(mat4 projectionMatrix, vec3 position){
    vec4 h = projectionMatrix * vec4(position, 1.0);
    return h.xyz / h.w;
}

const int times[6] = int[](0, 6000, 12785, 18000, 23215, 24000);
const vec3 fogValues[6] = vec3[](vec3(0.9, 0.8, 0.7), vec3(0.8, 0.8, 0.8), vec3(0.35, 0.25, 0.2), vec3(0.15, 0.15, 0.15), vec3(0.35, 0.25, 0.2), vec3(0.9, 0.8, 0.7));

vec3 fogColor(int t){
    for(int i = 0; i < 5; i++){
        if(t >= times[i] && t < times[i + 1]){
            float f = float(t - times[i]) / float(times[i + 1] - times[i]);
            return mix(fogValues[i], fogValues[i + 1], f);
        }
    }
    return fogValues[0];
}

void main(){
    color = texture(colortex0, texcoord);
    float depth = texture(depthtex0, texcoord).r;
    if(depth == 1.0) return;
    if(isEyeInWater == 1) return;

    vec3 NDCPos = vec3(texcoord.xy, depth) * 2.0 - 1.0;
    vec3 viewPos = projectAndDivide(gbufferProjectionInverse, NDCPos);
    float dist = length(viewPos) / far;
    float expFactor = (isEyeInWater == 2 || isEyeInWater == 3) ? -2.0 : -6.0;
    float fogFactor = clamp(exp(expFactor * (1.0 - dist)), 0.0, 1.0);

    vec3 finalFog = pow(fogColor(worldTime), vec3(2.2));
    color.rgb = mix(color.rgb, finalFog, fogFactor);
}
