#version 330 compatibility

#define BLOOM_INTENSITY 1.0 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

const bool colortex0MipmapEnabled = true;

uniform sampler2D colortex0;

in vec2 texcoord;

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 color;

void main() {
    color = texture(colortex0, texcoord);
    vec4 bloom0 = textureLod(colortex0, texcoord, 8.0);
    vec4 bloom1 = textureLod(colortex0, texcoord, 6.0);
    vec4 bloom2 = textureLod(colortex0, texcoord, 4.0);

    vec4 bright = pow(bloom0 + bloom1 + bloom2, vec4(2.5)) * 0.02 * BLOOM_INTENSITY;

    vec3 c = color.rgb;
    c = c / (c + vec3(0.15));
    color.rgb = c;

    color += bright;
}