#version 330 compatibility

#include "distort.glsl"

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D shadowtex0;
uniform sampler2D depthtex0;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;

uniform vec3 cameraPosition;
uniform vec3 shadowLightPosition;
uniform float rainStrength;
uniform int worldTime;
uniform int worldType;
uniform bool hasSkylight;

in vec2 texcoord;

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 color;

const vec3 blocklightColor = vec3(0.6, 0.3, 0.2) * 0.3;
const vec3 skylightColorDay = vec3(0.6, 0.6, 0.8) * 0.6;
const vec3 skylightColorNight = vec3(0.3, 0.4, 1.05) * 0.6;
const vec3 sunlightColorDay = vec3(1.0, 0.7, 0.4) * 0.6;
const vec3 sunlightColorNight = vec3(0.4, 0.5, 1.0) * 0.5;
const float sunPathRotation = -30.0;

const int times[6] = int[](0, 6000, 12785, 18000, 23215, 24000);
const float values[6] = float[](0.7, 1.2, 0.0, 0.01, 0.0, 0.7);

vec3 projectAndDivide(mat4 projectionMatrix, vec3 position){
  vec4 homPos = projectionMatrix * vec4(position, 1.0);
  return homPos.xyz / homPos.w;
}

void main() {
	color = texture(colortex0, texcoord);
	color.rgb = pow(color.rgb, vec3(2.2));

	float depth = texture(depthtex0, texcoord).r;
	if(depth == 1.0){
	  return;
	}

	float dayCycle = 0.0;
	for (int i = 0; i < 5; i++) {
 	   int t1 = times[i];
  	  int t2 = times[i + 1];
  	  float v1 = values[i];
  	  float v2 = values[i + 1];

  	  if (worldTime >= t1 && worldTime < t2) {
        float position = float(worldTime - t1) / float(t2 - t1);
        dayCycle = mix(v1, v2, clamp(position, 0.0, 1.0));
        break;
    }
}

	vec2 lightmap = texture(colortex1, texcoord).rg;
	vec3 encodedNormal = texture(colortex2, texcoord).rgb;
	vec3 normal = normalize((encodedNormal - 0.5) * 2.0);

	vec3 lightVector = normalize(shadowLightPosition);
	vec3 worldLightVector = mat3(gbufferModelViewInverse) * lightVector;

	vec3 NDCPos = vec3(texcoord.xy, depth) * 2.0 - 1.0;
	vec3 viewPos = projectAndDivide(gbufferProjectionInverse, NDCPos);
	vec3 feetPlayerPos = (gbufferModelViewInverse * vec4(viewPos, 1.0)).xyz;
	vec3 shadowViewPos = (shadowModelView * vec4(feetPlayerPos, 1.0)).xyz;
	vec4 shadowClipPos = shadowProjection * vec4(shadowViewPos, 1.0);
	shadowClipPos.z -= 0.0005;
	shadowClipPos.xyz = distortShadowClipPos(shadowClipPos.xyz);
	vec3 shadowNDCPos = shadowClipPos.xyz / shadowClipPos.w;
	vec3 shadowScreenPos = shadowNDCPos * 0.5 + 0.5;

	float shadow = 0.0;
	if (depth < 1.0) {
	    shadow = step(shadowScreenPos.z, texture(shadowtex0, shadowScreenPos.xy).r);
	}

	vec3 blocklight = lightmap.r * mix(blocklightColor, vec3(1.3, 1.1, 1.0), pow(lightmap.r, 2.0));

	vec3 currentSkylightColor = mix(skylightColorNight, skylightColorDay, dayCycle);
	vec3 skylight = pow(lightmap.g, 2.0) * currentSkylightColor;

	vec3 currentSunlightColor = mix(sunlightColorNight, sunlightColorDay, dayCycle);
	vec3 sunlight = currentSunlightColor * clamp(dot(worldLightVector, normal), 0.0, 1.0) * shadow * lightmap.g;

	color.rgb *= pow(blocklight * 1.2, vec3(2.5)) + (skylight + sunlight * (1.1 - rainStrength)) * dayCycle + vec3(0.01, 0.01, 0.015);
}