#version 330 compatibility

#include "distort.glsl"

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D depthtex0;
uniform sampler2D shadowtex0;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform vec3 shadowLightPosition;
uniform int worldTime;
uniform bool hasSkylight;

const vec3 blocklightColor = vec3(1.0, 0.4, 0.2) * 3.0;
const vec3 skylightColor = vec3(0.3, 0.35, 0.5);
const vec3 sunlightColor = vec3(2.0, 0.9, 0.4) * 2.0;

const int times[6] = int[](0, 6000, 12785, 18000, 23215, 24000);
const float values[6] = float[](0.7, 0.8, 0.0, 0.01, 0.0, 0.7);

in vec2 texcoord;

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 color;

vec3 projectAndDivide(mat4 projectionMatrix, vec3 position){
  vec4 homPos = projectionMatrix * vec4(position, 1.0);
  return homPos.xyz / homPos.w;
}

void main() {
    color = texture(colortex0, texcoord);
	float depth = texture(depthtex0, texcoord).r;
	if (depth == 1.0) return;

		float dayCycle = 0.0;
	for (int i = 0; i < 5; i++) {
 	   int t1 = times[i];
  	  int t2 = times[i + 1];
  	  float v1 = values[i];
  	  float v2 = values[i + 1];

  	  if (worldTime >= t1 && worldTime < t2) {
        float position = float(worldTime - t1) / float(t2 - t1);
        dayCycle = mix(v1, v2, clamp(position, 0.0, 1.0));
        break;
	  }
	}


    vec2 lightmap = pow(texture(colortex1, texcoord).rg, vec2(3.0));
    vec3 normalData = texture(colortex2, texcoord).rgb;
    vec3 normal = normalize((normalData - 0.5) * 2.0);

    vec3 psNormal = inverse(mat3(gbufferModelViewInverse)) * normal;

	vec3 NDCPos = vec3(texcoord.xy, depth) * 2.0 - 1.0;
	vec3 viewPos = projectAndDivide(gbufferProjectionInverse, NDCPos);
	vec3 feetPlayerPos = (gbufferModelViewInverse * vec4(viewPos, 1.0)).xyz;
	vec3 shadowViewPos = (shadowModelView * vec4(feetPlayerPos, 1.0)).xyz;
	vec4 shadowClipPos = shadowProjection * vec4(shadowViewPos, 1.0);
	shadowClipPos.z -= 0.001;
	shadowClipPos.xyz = distortShadowClipPos(shadowClipPos.xyz);
	vec3 shadowNDCPos = shadowClipPos.xyz / shadowClipPos.w;
	vec3 shadowScreenPos = shadowNDCPos * 0.5 + 0.5;

	vec3 lightVector = normalize(shadowLightPosition);
	vec3 worldLightVector = mat3(gbufferModelViewInverse) * lightVector;

	float shadow = step(shadowScreenPos.z, texture(shadowtex0, shadowScreenPos.xy).r);

	vec3 blocklight = lightmap.r * blocklightColor;
	vec3 skylight = lightmap.g * skylightColor;
	vec3 sunlight = sunlightColor * clamp(dot(worldLightVector, normal), 0.0, 1.0) * shadow * lightmap.g;
	
	vec3 viewDir = normalize(feetPlayerPos - viewPos);
	float fresnel = pow(1.0 - dot(viewDir, psNormal), 3.0) * 0.1;

	color.rgb = pow(color.rgb, vec3(2.2));
	color.rgb += vec3(fresnel) * 0.1;
	color.rgb *= blocklight + (skylight * dayCycle) + sunlight * dayCycle + (hasSkylight ? vec3(0.02, 0.023, 0.035) : vec3(0.05, 0.02, 0.02));
}