#version 330 compatibility

/*
const int colortex0Format = RGB16F;
*/

uniform sampler2D colortex0;

in vec2 texcoord;

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 color;

vec3 tonemap(vec3 x) {
    const float a = 3.0;
    const float b = 0.1;
    const float c = 2.5;
    const float d = 1.0;
    const float e = 0.2;
    return clamp((x * (a * x + b)) / (x * (c * x + d) + e), 0.0, 1.0);
}

void main() {
    vec3 hdrColor = pow(texture(colortex0, texcoord).rgb, vec3(1.0 / 2.2));

    float brightness = max(hdrColor.r, max(hdrColor.g, hdrColor.b));
    float whiteFactor = smoothstep(1.0, 1.5, brightness);
    hdrColor += hdrColor * whiteFactor * 0.5;

    hdrColor = tonemap(hdrColor);

    float lum = (hdrColor.r + hdrColor.g + hdrColor.b) / 3.0;
    float darkFactor = clamp(1.0 - lum * 5.0, 0.0, 1.0);
    vec3 gray = vec3(lum);
    hdrColor = mix(hdrColor, gray, darkFactor);

    hdrColor = mix(gray, hdrColor, 1.2);

    color = vec4(hdrColor, 1.0);
}