#version 330 compatibility

uniform int renderStage;
uniform float viewHeight;
uniform float viewWidth;
uniform mat4 gbufferModelView;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferProjection;
uniform vec3 fogColor;
uniform vec3 skyColor;
uniform vec3 sunPosition;

in vec4 glcolor;

float fogify(float x, float w) {
	return w / (x * x + w);
}

vec3 calcSkyColor(vec3 pos) {
    float upDot = dot(pos, gbufferModelView[1].xyz);
    vec3 baseColor = skyColor * mix(vec3(0.7, 0.8, 0.6), skyColor * vec3(0.8, 0.5, 0.4), upDot);
    return mix(baseColor, fogColor * vec3(1.2, 1.15, 1.0), fogify(max(upDot, 0.0), 0.025));
}

vec3 screenToView(vec3 screenPos) {
	vec4 ndcPos = vec4(screenPos, 1.0) * 2.0 - 1.0;
	vec4 tmp = gbufferProjectionInverse * ndcPos;
	return tmp.xyz / tmp.w;
}

vec2 getSunScreenPos() {
    vec4 clip = gbufferProjection * vec4(sunPosition, 1.0);
    clip /= clip.w;
    return clip.xy * 0.5 + 0.5;
}

/* RENDERTARGETS: 0 */
layout(location = 0) out vec4 color;

void main() {
	if (renderStage == MC_RENDER_STAGE_STARS) {
		color = glcolor * 0.3;
	} else {
        	vec3 pos = screenToView(vec3(gl_FragCoord.xy / vec2(viewWidth, viewHeight), 1.0));
	vec3 col = calcSkyColor(normalize(pos));

    vec2 fragScreen = gl_FragCoord.xy / vec2(viewWidth, viewHeight);
    vec2 sunScreen = getSunScreenPos();
    vec2 diff = fragScreen - sunScreen;
    diff.x *= viewWidth / viewHeight;
    float dist = length(diff);
    float glow = exp(-dist * 6.0);
    col += fogColor * vec3(1.0, 0.5, 0.2) * glow;

	color = vec4(col, 0.0);
	color.rgb = pow(color.rgb, vec3(2.2));	
	}
}
